<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNodeFromDriver StructType
 * @subpackage Structs
 */
class GetNodeFromDriver extends AbstractStructBase
{
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The PIN1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN1;
    /**
     * The PIN2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN2;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Driver;
    /**
     * Constructor method for GetNodeFromDriver
     * @uses GetNodeFromDriver::setUsername()
     * @uses GetNodeFromDriver::setPIN1()
     * @uses GetNodeFromDriver::setPIN2()
     * @uses GetNodeFromDriver::setDriver()
     * @param string $username
     * @param string $pIN1
     * @param string $pIN2
     * @param string $driver
     */
    public function __construct($username = null, $pIN1 = null, $pIN2 = null, $driver = null)
    {
        $this
            ->setUsername($username)
            ->setPIN1($pIN1)
            ->setPIN2($pIN2)
            ->setDriver($driver);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\GetNodeFromDriver
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get PIN1 value
     * @return string|null
     */
    public function getPIN1()
    {
        return $this->PIN1;
    }
    /**
     * Set PIN1 value
     * @param string $pIN1
     * @return \StructType\GetNodeFromDriver
     */
    public function setPIN1($pIN1 = null)
    {
        // validation for constraint: string
        if (!is_null($pIN1) && !is_string($pIN1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN1, true), gettype($pIN1)), __LINE__);
        }
        $this->PIN1 = $pIN1;
        return $this;
    }
    /**
     * Get PIN2 value
     * @return string|null
     */
    public function getPIN2()
    {
        return $this->PIN2;
    }
    /**
     * Set PIN2 value
     * @param string $pIN2
     * @return \StructType\GetNodeFromDriver
     */
    public function setPIN2($pIN2 = null)
    {
        // validation for constraint: string
        if (!is_null($pIN2) && !is_string($pIN2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN2, true), gettype($pIN2)), __LINE__);
        }
        $this->PIN2 = $pIN2;
        return $this;
    }
    /**
     * Get Driver value
     * @return string|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param string $driver
     * @return \StructType\GetNodeFromDriver
     */
    public function setDriver($driver = null)
    {
        // validation for constraint: string
        if (!is_null($driver) && !is_string($driver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driver, true), gettype($driver)), __LINE__);
        }
        $this->Driver = $driver;
        return $this;
    }
}
