<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Door ServiceType
 * @subpackage Services
 */
class Door extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DoorAlarm
     * Meta information extracted from the WSDL
     * - documentation: Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi alarmi ek donanim (kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. - It lists door alerts. With this method, the door alarms generated by
     * the device are listed in the vehicles with the door open / close alarm additional equipment (door sensor) . | Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi alarmi ek donanim (kapi sensoru) bulunan araclarda cihaz tarafindan uretilen
     * alarmlar listelenir. - It lists door alerts. With this method, the door alarms generated by the device are listed in the vehicles with the door open / close alarm additional equipment (door sensor) . | Kapi alarmlarini listeler. Bu metot ile kapi
     * acildi / kapandi alarmi ek donanim (kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. - It lists door alerts. With this method, the door alarms generated by the device are listed in the vehicles with the door open / close
     * alarm additional equipment (door sensor) .
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorAlarm $parameters
     * @return \StructType\DoorAlarmResponse|bool
     */
    public function DoorAlarm(\StructType\DoorAlarm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DoorAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DoorAlarmReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi alarmi ek donanim (kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. DoorAlarm methodundan farkli olarak sonucu XmlDocument tipinde dondurur.
     * - It lists door alerts. With this method, the door alarms generated by the device are listed in the vehicles with the door open / close alarm additional equipment (door sensor), returns the result as XmlDocument type. | Kapi alarmlarini listeler. Bu
     * metot ile kapi acildi / kapandi alarmi ek donanim (kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. DoorAlarm methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It lists door alerts. With this method, the
     * door alarms generated by the device are listed in the vehicles with the door open / close alarm additional equipment (door sensor), returns the result as XmlDocument type. | Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi alarmi ek
     * donanim (kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. DoorAlarm methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It lists door alerts. With this method, the door alarms generated by the device are
     * listed in the vehicles with the door open / close alarm additional equipment (door sensor), returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorAlarmReturnObject $parameters
     * @return \StructType\DoorAlarmReturnObjectResponse|bool
     */
    public function DoorAlarmReturnObject(\StructType\DoorAlarmReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DoorAlarmReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DoorAlarm2
     * Meta information extracted from the WSDL
     * - documentation: Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi alarmi ek donanim(kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. - It lists door alerts. With this method, alarms generated by the device
     * are listed in the vehicles with the door open / close alarm additional equipment (door sensor). | Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi alarmi ek donanim(kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar
     * listelenir. - It lists door alerts. With this method, alarms generated by the device are listed in the vehicles with the door open / close alarm additional equipment (door sensor). | Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi
     * alarmi ek donanim(kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. - It lists door alerts. With this method, alarms generated by the device are listed in the vehicles with the door open / close alarm additional equipment
     * (door sensor).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorAlarm2 $parameters
     * @return \StructType\DoorAlarm2Response|bool
     */
    public function DoorAlarm2(\StructType\DoorAlarm2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DoorAlarm2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DoorAlarm2ReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi alarmi ek donanim(kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. DoorAlarm2 methodundan farkli olarak sonucu XmlDocument tipinde dondurur.
     * - It lists door alerts. With this method, alarms generated by the device are listed in the vehicles with the door open / close alarm additional equipment (door sensor), returns the result as XmlDocument type. | Kapi alarmlarini listeler. Bu metot ile
     * kapi acildi / kapandi alarmi ek donanim(kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. DoorAlarm2 methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It lists door alerts. With this method, alarms
     * generated by the device are listed in the vehicles with the door open / close alarm additional equipment (door sensor), returns the result as XmlDocument type. | Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi alarmi ek donanim(kapi
     * sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. DoorAlarm2 methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It lists door alerts. With this method, alarms generated by the device are listed in the vehicles
     * with the door open / close alarm additional equipment (door sensor), returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorAlarm2ReturnObject $parameters
     * @return \StructType\DoorAlarm2ReturnObjectResponse|bool
     */
    public function DoorAlarm2ReturnObject(\StructType\DoorAlarm2ReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DoorAlarm2ReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DoorAlarm2Response|\StructType\DoorAlarm2ReturnObjectResponse|\StructType\DoorAlarmResponse|\StructType\DoorAlarmReturnObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
