<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Parallel ServiceType
 * @subpackage Services
 */
class Parallel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ParallelTimingReport
     * Meta information extracted from the WSDL
     * - documentation: Aracin toplam mesafesini, toplam yakit tuketimini ve ortalama yakit tuketimini listelemektedir. - It lists the vehicle’s total distance, total fuel consumption and average fuel consumption. | Aracin toplam mesafesini, toplam yakit
     * tuketimini ve ortalama yakit tuketimini listelemektedir. - It lists the vehicle’s total distance, total fuel consumption and average fuel consumption. | Aracin toplam mesafesini, toplam yakit tuketimini ve ortalama yakit tuketimini listelemektedir.
     * - It lists the vehicle’s total distance, total fuel consumption and average fuel consumption.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ParallelTimingReport $parameters
     * @return \StructType\ParallelTimingReportResponse|bool
     */
    public function ParallelTimingReport(\StructType\ParallelTimingReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ParallelTimingReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ParallelTimingReportReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Aracin toplam mesafesini, toplam yakit tuketimini ve ortalama yakit tuketimini listelemektedir. ParallelTimingReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It lists the vehicle’s total distance, total fuel
     * consumption and average fuel consumption, returns the result as XmlDocument type. | Aracin toplam mesafesini, toplam yakit tuketimini ve ortalama yakit tuketimini listelemektedir. ParallelTimingReport methodundan farkli olarak sonucu XmlDocument
     * tipinde dondurur. - It lists the vehicle’s total distance, total fuel consumption and average fuel consumption, returns the result as XmlDocument type. | Aracin toplam mesafesini, toplam yakit tuketimini ve ortalama yakit tuketimini
     * listelemektedir. ParallelTimingReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It lists the vehicle’s total distance, total fuel consumption and average fuel consumption, returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ParallelTimingReportReturnObject $parameters
     * @return \StructType\ParallelTimingReportReturnObjectResponse|bool
     */
    public function ParallelTimingReportReturnObject(\StructType\ParallelTimingReportReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ParallelTimingReportReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ParallelTimingReportResponse|\StructType\ParallelTimingReportReturnObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
