<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNearestNodesReturnObject StructType
 * @subpackage Structs
 */
class GetNearestNodesReturnObject extends AbstractStructBase
{
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The PIN1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN1;
    /**
     * The PIN2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN2;
    /**
     * The LongitudeX
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LongitudeX;
    /**
     * The LatitudeY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LatitudeY;
    /**
     * The Radius
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Radius;
    /**
     * The DisplayDurationInMinutes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayDurationInMinutes;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The Locale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Locale;
    /**
     * Constructor method for GetNearestNodesReturnObject
     * @uses GetNearestNodesReturnObject::setUsername()
     * @uses GetNearestNodesReturnObject::setPIN1()
     * @uses GetNearestNodesReturnObject::setPIN2()
     * @uses GetNearestNodesReturnObject::setLongitudeX()
     * @uses GetNearestNodesReturnObject::setLatitudeY()
     * @uses GetNearestNodesReturnObject::setRadius()
     * @uses GetNearestNodesReturnObject::setDisplayDurationInMinutes()
     * @uses GetNearestNodesReturnObject::setLanguage()
     * @uses GetNearestNodesReturnObject::setLocale()
     * @param string $username
     * @param string $pIN1
     * @param string $pIN2
     * @param string $longitudeX
     * @param string $latitudeY
     * @param string $radius
     * @param string $displayDurationInMinutes
     * @param string $language
     * @param string $locale
     */
    public function __construct($username = null, $pIN1 = null, $pIN2 = null, $longitudeX = null, $latitudeY = null, $radius = null, $displayDurationInMinutes = null, $language = null, $locale = null)
    {
        $this
            ->setUsername($username)
            ->setPIN1($pIN1)
            ->setPIN2($pIN2)
            ->setLongitudeX($longitudeX)
            ->setLatitudeY($latitudeY)
            ->setRadius($radius)
            ->setDisplayDurationInMinutes($displayDurationInMinutes)
            ->setLanguage($language)
            ->setLocale($locale);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\GetNearestNodesReturnObject
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get PIN1 value
     * @return string|null
     */
    public function getPIN1()
    {
        return $this->PIN1;
    }
    /**
     * Set PIN1 value
     * @param string $pIN1
     * @return \StructType\GetNearestNodesReturnObject
     */
    public function setPIN1($pIN1 = null)
    {
        // validation for constraint: string
        if (!is_null($pIN1) && !is_string($pIN1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN1, true), gettype($pIN1)), __LINE__);
        }
        $this->PIN1 = $pIN1;
        return $this;
    }
    /**
     * Get PIN2 value
     * @return string|null
     */
    public function getPIN2()
    {
        return $this->PIN2;
    }
    /**
     * Set PIN2 value
     * @param string $pIN2
     * @return \StructType\GetNearestNodesReturnObject
     */
    public function setPIN2($pIN2 = null)
    {
        // validation for constraint: string
        if (!is_null($pIN2) && !is_string($pIN2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN2, true), gettype($pIN2)), __LINE__);
        }
        $this->PIN2 = $pIN2;
        return $this;
    }
    /**
     * Get LongitudeX value
     * @return string|null
     */
    public function getLongitudeX()
    {
        return $this->LongitudeX;
    }
    /**
     * Set LongitudeX value
     * @param string $longitudeX
     * @return \StructType\GetNearestNodesReturnObject
     */
    public function setLongitudeX($longitudeX = null)
    {
        // validation for constraint: string
        if (!is_null($longitudeX) && !is_string($longitudeX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longitudeX, true), gettype($longitudeX)), __LINE__);
        }
        $this->LongitudeX = $longitudeX;
        return $this;
    }
    /**
     * Get LatitudeY value
     * @return string|null
     */
    public function getLatitudeY()
    {
        return $this->LatitudeY;
    }
    /**
     * Set LatitudeY value
     * @param string $latitudeY
     * @return \StructType\GetNearestNodesReturnObject
     */
    public function setLatitudeY($latitudeY = null)
    {
        // validation for constraint: string
        if (!is_null($latitudeY) && !is_string($latitudeY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitudeY, true), gettype($latitudeY)), __LINE__);
        }
        $this->LatitudeY = $latitudeY;
        return $this;
    }
    /**
     * Get Radius value
     * @return string|null
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param string $radius
     * @return \StructType\GetNearestNodesReturnObject
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: string
        if (!is_null($radius) && !is_string($radius)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($radius, true), gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get DisplayDurationInMinutes value
     * @return string|null
     */
    public function getDisplayDurationInMinutes()
    {
        return $this->DisplayDurationInMinutes;
    }
    /**
     * Set DisplayDurationInMinutes value
     * @param string $displayDurationInMinutes
     * @return \StructType\GetNearestNodesReturnObject
     */
    public function setDisplayDurationInMinutes($displayDurationInMinutes = null)
    {
        // validation for constraint: string
        if (!is_null($displayDurationInMinutes) && !is_string($displayDurationInMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayDurationInMinutes, true), gettype($displayDurationInMinutes)), __LINE__);
        }
        $this->DisplayDurationInMinutes = $displayDurationInMinutes;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\GetNearestNodesReturnObject
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param string $locale
     * @return \StructType\GetNearestNodesReturnObject
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: string
        if (!is_null($locale) && !is_string($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locale, true), gettype($locale)), __LINE__);
        }
        $this->Locale = $locale;
        return $this;
    }
}
