<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Idling ServiceType
 * @subpackage Services
 */
class Idling extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IdlingDurationReport
     * Meta information extracted from the WSDL
     * - documentation: Rolanti zamani bilgisi listeler. Rolanti aracin kontaginin acik olup hareket etmedigi durumdur. Bu metot ile cihazin yaptigi rolanti sureleri detayli gosterilir. - List the idling durations information. Idling is when the vehicle
     * ignition is on and not moving. With this method, the idling times of the device are shown in detail. | Rolanti zamani bilgisi listeler. Rolanti aracin kontaginin acik olup hareket etmedigi durumdur. Bu metot ile cihazin yaptigi rolanti sureleri
     * detayli gosterilir. - List the idling durations information. Idling is when the vehicle ignition is on and not moving. With this method, the idling times of the device are shown in detail. | Rolanti zamani bilgisi listeler. Rolanti aracin kontaginin
     * acik olup hareket etmedigi durumdur. Bu metot ile cihazin yaptigi rolanti sureleri detayli gosterilir. - List the idling durations information. Idling is when the vehicle ignition is on and not moving. With this method, the idling times of the device
     * are shown in detail.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IdlingDurationReport $parameters
     * @return \StructType\IdlingDurationReportResponse|bool
     */
    public function IdlingDurationReport(\StructType\IdlingDurationReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IdlingDurationReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IdlingDurationReportReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Rolanti zamani bilgisi listeler. Rolanti aracin kontaginin acik olup hareket etmedigi durumdur. Bu metot ile cihazin yaptigi rolanti sureleri detayli gosterilir. IdlingDurationReport methodundan farkli olarak sonucu XmlDocument
     * tipinde dondurur. - List the idling durations information. Idling is when the vehicle ignition is on and not moving. With this method, the idling times of the device are shown in detail, returns the result as XmlDocument type. | Rolanti zamani
     * bilgisi listeler. Rolanti aracin kontaginin acik olup hareket etmedigi durumdur. Bu metot ile cihazin yaptigi rolanti sureleri detayli gosterilir. IdlingDurationReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - List the idling
     * durations information. Idling is when the vehicle ignition is on and not moving. With this method, the idling times of the device are shown in detail, returns the result as XmlDocument type. | Rolanti zamani bilgisi listeler. Rolanti aracin
     * kontaginin acik olup hareket etmedigi durumdur. Bu metot ile cihazin yaptigi rolanti sureleri detayli gosterilir. IdlingDurationReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - List the idling durations information. Idling is
     * when the vehicle ignition is on and not moving. With this method, the idling times of the device are shown in detail, returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IdlingDurationReportReturnObject $parameters
     * @return \StructType\IdlingDurationReportReturnObjectResponse|bool
     */
    public function IdlingDurationReportReturnObject(\StructType\IdlingDurationReportReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IdlingDurationReportReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IdlingAlarm
     * Meta information extracted from the WSDL
     * - documentation: Cihazlardan gelen rolanti alarmlarini listeler. Bu metot ile, aracin hangi bolgelerde ne zaman rolanti suresini ihlal ettigi gosterilir. - Lists the idling alarms from the devices. With this method, it is shown vehicle has violated
     * the idling time | Cihazlardan gelen rolanti alarmlarini listeler. Bu metot ile, aracin hangi bolgelerde ne zaman rolanti suresini ihlal ettigi gosterilir. - Lists the idling alarms from the devices. With this method, it is shown vehicle has violated
     * the idling time | Cihazlardan gelen rolanti alarmlarini listeler. Bu metot ile, aracin hangi bolgelerde ne zaman rolanti suresini ihlal ettigi gosterilir. - Lists the idling alarms from the devices. With this method, it is shown vehicle has violated
     * the idling time
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IdlingAlarm $parameters
     * @return \StructType\IdlingAlarmResponse|bool
     */
    public function IdlingAlarm(\StructType\IdlingAlarm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IdlingAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IdlingAlarmReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Cihazlardan gelen rolanti alarmlarini listeler. Bu metot ile, aracin hangi bolgelerde ne zaman rolanti suresini ihlal ettigi gosterilir. IdlingAlarm methodundan farkli olarak sonucu XmlDocument tipinde dondurur - Lists the idling
     * alarms from the devices. With this method, it is shown vehicle has violated the idling time, returns the result as XmlDocument type. | Cihazlardan gelen rolanti alarmlarini listeler. Bu metot ile, aracin hangi bolgelerde ne zaman rolanti suresini
     * ihlal ettigi gosterilir. IdlingAlarm methodundan farkli olarak sonucu XmlDocument tipinde dondurur - Lists the idling alarms from the devices. With this method, it is shown vehicle has violated the idling time, returns the result as XmlDocument type.
     * | Cihazlardan gelen rolanti alarmlarini listeler. Bu metot ile, aracin hangi bolgelerde ne zaman rolanti suresini ihlal ettigi gosterilir. IdlingAlarm methodundan farkli olarak sonucu XmlDocument tipinde dondurur - Lists the idling alarms from the
     * devices. With this method, it is shown vehicle has violated the idling time, returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IdlingAlarmReturnObject $parameters
     * @return \StructType\IdlingAlarmReturnObjectResponse|bool
     */
    public function IdlingAlarmReturnObject(\StructType\IdlingAlarmReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IdlingAlarmReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IdlingAlarmResponse|\StructType\IdlingAlarmReturnObjectResponse|\StructType\IdlingDurationReportResponse|\StructType\IdlingDurationReportReturnObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
