<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNodeFromLicensePlate StructType
 * @subpackage Structs
 */
class GetNodeFromLicensePlate extends AbstractStructBase
{
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The PIN1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN1;
    /**
     * The PIN2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN2;
    /**
     * The LicensePlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * Constructor method for GetNodeFromLicensePlate
     * @uses GetNodeFromLicensePlate::setUsername()
     * @uses GetNodeFromLicensePlate::setPIN1()
     * @uses GetNodeFromLicensePlate::setPIN2()
     * @uses GetNodeFromLicensePlate::setLicensePlate()
     * @param string $username
     * @param string $pIN1
     * @param string $pIN2
     * @param string $licensePlate
     */
    public function __construct($username = null, $pIN1 = null, $pIN2 = null, $licensePlate = null)
    {
        $this
            ->setUsername($username)
            ->setPIN1($pIN1)
            ->setPIN2($pIN2)
            ->setLicensePlate($licensePlate);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\GetNodeFromLicensePlate
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get PIN1 value
     * @return string|null
     */
    public function getPIN1()
    {
        return $this->PIN1;
    }
    /**
     * Set PIN1 value
     * @param string $pIN1
     * @return \StructType\GetNodeFromLicensePlate
     */
    public function setPIN1($pIN1 = null)
    {
        // validation for constraint: string
        if (!is_null($pIN1) && !is_string($pIN1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN1, true), gettype($pIN1)), __LINE__);
        }
        $this->PIN1 = $pIN1;
        return $this;
    }
    /**
     * Get PIN2 value
     * @return string|null
     */
    public function getPIN2()
    {
        return $this->PIN2;
    }
    /**
     * Set PIN2 value
     * @param string $pIN2
     * @return \StructType\GetNodeFromLicensePlate
     */
    public function setPIN2($pIN2 = null)
    {
        // validation for constraint: string
        if (!is_null($pIN2) && !is_string($pIN2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN2, true), gettype($pIN2)), __LINE__);
        }
        $this->PIN2 = $pIN2;
        return $this;
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \StructType\GetNodeFromLicensePlate
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlate, true), gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
}
