<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLastPacket ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLastPacket
 * @subpackage Arrays
 */
class ArrayOfLastPacket extends AbstractStructArrayBase
{
    /**
     * The LastPacket
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LastPacket[]
     */
    public $LastPacket;
    /**
     * Constructor method for ArrayOfLastPacket
     * @uses ArrayOfLastPacket::setLastPacket()
     * @param \StructType\LastPacket[] $lastPacket
     */
    public function __construct(array $lastPacket = array())
    {
        $this
            ->setLastPacket($lastPacket);
    }
    /**
     * Get LastPacket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LastPacket[]|null
     */
    public function getLastPacket()
    {
        return isset($this->LastPacket) ? $this->LastPacket : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLastPacket method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastPacket method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLastPacketForArrayConstraintsFromSetLastPacket(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLastPacketLastPacketItem) {
            // validation for constraint: itemType
            if (!$arrayOfLastPacketLastPacketItem instanceof \StructType\LastPacket) {
                $invalidValues[] = is_object($arrayOfLastPacketLastPacketItem) ? get_class($arrayOfLastPacketLastPacketItem) : sprintf('%s(%s)', gettype($arrayOfLastPacketLastPacketItem), var_export($arrayOfLastPacketLastPacketItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LastPacket property can only contain items of type \StructType\LastPacket, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LastPacket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LastPacket[] $lastPacket
     * @return \ArrayType\ArrayOfLastPacket
     */
    public function setLastPacket(array $lastPacket = array())
    {
        // validation for constraint: array
        if ('' !== ($lastPacketArrayErrorMessage = self::validateLastPacketForArrayConstraintsFromSetLastPacket($lastPacket))) {
            throw new \InvalidArgumentException($lastPacketArrayErrorMessage, __LINE__);
        }
        if (is_null($lastPacket) || (is_array($lastPacket) && empty($lastPacket))) {
            unset($this->LastPacket);
        } else {
            $this->LastPacket = $lastPacket;
        }
        return $this;
    }
    /**
     * Add item to LastPacket value
     * @throws \InvalidArgumentException
     * @param \StructType\LastPacket $item
     * @return \ArrayType\ArrayOfLastPacket
     */
    public function addToLastPacket(\StructType\LastPacket $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LastPacket) {
            throw new \InvalidArgumentException(sprintf('The LastPacket property can only contain items of type \StructType\LastPacket, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LastPacket[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LastPacket|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LastPacket|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LastPacket|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LastPacket|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LastPacket|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LastPacket
     */
    public function getAttributeName()
    {
        return 'LastPacket';
    }
}
