<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LastPacket StructType
 * @subpackage Structs
 */
class LastPacket extends AbstractStructBase
{
    /**
     * The dtGMTDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dtGMTDateTime;
    /**
     * The dLatitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $dLatitude;
    /**
     * The dLongitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $dLongitude;
    /**
     * The dSpeed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $dSpeed;
    /**
     * The nCourse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nCourse;
    /**
     * The dOdometer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $dOdometer;
    /**
     * The nAltitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nAltitude;
    /**
     * The strNode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $strNode;
    /**
     * The strAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $strAddress;
    /**
     * The strRegion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $strRegion;
    /**
     * Constructor method for LastPacket
     * @uses LastPacket::setDtGMTDateTime()
     * @uses LastPacket::setDLatitude()
     * @uses LastPacket::setDLongitude()
     * @uses LastPacket::setDSpeed()
     * @uses LastPacket::setNCourse()
     * @uses LastPacket::setDOdometer()
     * @uses LastPacket::setNAltitude()
     * @uses LastPacket::setStrNode()
     * @uses LastPacket::setStrAddress()
     * @uses LastPacket::setStrRegion()
     * @param string $dtGMTDateTime
     * @param float $dLatitude
     * @param float $dLongitude
     * @param float $dSpeed
     * @param int $nCourse
     * @param float $dOdometer
     * @param int $nAltitude
     * @param string $strNode
     * @param string $strAddress
     * @param string $strRegion
     */
    public function __construct($dtGMTDateTime = null, $dLatitude = null, $dLongitude = null, $dSpeed = null, $nCourse = null, $dOdometer = null, $nAltitude = null, $strNode = null, $strAddress = null, $strRegion = null)
    {
        $this
            ->setDtGMTDateTime($dtGMTDateTime)
            ->setDLatitude($dLatitude)
            ->setDLongitude($dLongitude)
            ->setDSpeed($dSpeed)
            ->setNCourse($nCourse)
            ->setDOdometer($dOdometer)
            ->setNAltitude($nAltitude)
            ->setStrNode($strNode)
            ->setStrAddress($strAddress)
            ->setStrRegion($strRegion);
    }
    /**
     * Get dtGMTDateTime value
     * @return string
     */
    public function getDtGMTDateTime()
    {
        return $this->dtGMTDateTime;
    }
    /**
     * Set dtGMTDateTime value
     * @param string $dtGMTDateTime
     * @return \StructType\LastPacket
     */
    public function setDtGMTDateTime($dtGMTDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dtGMTDateTime) && !is_string($dtGMTDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtGMTDateTime, true), gettype($dtGMTDateTime)), __LINE__);
        }
        $this->dtGMTDateTime = $dtGMTDateTime;
        return $this;
    }
    /**
     * Get dLatitude value
     * @return float
     */
    public function getDLatitude()
    {
        return $this->dLatitude;
    }
    /**
     * Set dLatitude value
     * @param float $dLatitude
     * @return \StructType\LastPacket
     */
    public function setDLatitude($dLatitude = null)
    {
        // validation for constraint: float
        if (!is_null($dLatitude) && !(is_float($dLatitude) || is_numeric($dLatitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dLatitude, true), gettype($dLatitude)), __LINE__);
        }
        $this->dLatitude = $dLatitude;
        return $this;
    }
    /**
     * Get dLongitude value
     * @return float
     */
    public function getDLongitude()
    {
        return $this->dLongitude;
    }
    /**
     * Set dLongitude value
     * @param float $dLongitude
     * @return \StructType\LastPacket
     */
    public function setDLongitude($dLongitude = null)
    {
        // validation for constraint: float
        if (!is_null($dLongitude) && !(is_float($dLongitude) || is_numeric($dLongitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dLongitude, true), gettype($dLongitude)), __LINE__);
        }
        $this->dLongitude = $dLongitude;
        return $this;
    }
    /**
     * Get dSpeed value
     * @return float
     */
    public function getDSpeed()
    {
        return $this->dSpeed;
    }
    /**
     * Set dSpeed value
     * @param float $dSpeed
     * @return \StructType\LastPacket
     */
    public function setDSpeed($dSpeed = null)
    {
        // validation for constraint: float
        if (!is_null($dSpeed) && !(is_float($dSpeed) || is_numeric($dSpeed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dSpeed, true), gettype($dSpeed)), __LINE__);
        }
        $this->dSpeed = $dSpeed;
        return $this;
    }
    /**
     * Get nCourse value
     * @return int
     */
    public function getNCourse()
    {
        return $this->nCourse;
    }
    /**
     * Set nCourse value
     * @param int $nCourse
     * @return \StructType\LastPacket
     */
    public function setNCourse($nCourse = null)
    {
        // validation for constraint: int
        if (!is_null($nCourse) && !(is_int($nCourse) || ctype_digit($nCourse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nCourse, true), gettype($nCourse)), __LINE__);
        }
        $this->nCourse = $nCourse;
        return $this;
    }
    /**
     * Get dOdometer value
     * @return float
     */
    public function getDOdometer()
    {
        return $this->dOdometer;
    }
    /**
     * Set dOdometer value
     * @param float $dOdometer
     * @return \StructType\LastPacket
     */
    public function setDOdometer($dOdometer = null)
    {
        // validation for constraint: float
        if (!is_null($dOdometer) && !(is_float($dOdometer) || is_numeric($dOdometer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dOdometer, true), gettype($dOdometer)), __LINE__);
        }
        $this->dOdometer = $dOdometer;
        return $this;
    }
    /**
     * Get nAltitude value
     * @return int
     */
    public function getNAltitude()
    {
        return $this->nAltitude;
    }
    /**
     * Set nAltitude value
     * @param int $nAltitude
     * @return \StructType\LastPacket
     */
    public function setNAltitude($nAltitude = null)
    {
        // validation for constraint: int
        if (!is_null($nAltitude) && !(is_int($nAltitude) || ctype_digit($nAltitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nAltitude, true), gettype($nAltitude)), __LINE__);
        }
        $this->nAltitude = $nAltitude;
        return $this;
    }
    /**
     * Get strNode value
     * @return string|null
     */
    public function getStrNode()
    {
        return $this->strNode;
    }
    /**
     * Set strNode value
     * @param string $strNode
     * @return \StructType\LastPacket
     */
    public function setStrNode($strNode = null)
    {
        // validation for constraint: string
        if (!is_null($strNode) && !is_string($strNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strNode, true), gettype($strNode)), __LINE__);
        }
        $this->strNode = $strNode;
        return $this;
    }
    /**
     * Get strAddress value
     * @return string|null
     */
    public function getStrAddress()
    {
        return $this->strAddress;
    }
    /**
     * Set strAddress value
     * @param string $strAddress
     * @return \StructType\LastPacket
     */
    public function setStrAddress($strAddress = null)
    {
        // validation for constraint: string
        if (!is_null($strAddress) && !is_string($strAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strAddress, true), gettype($strAddress)), __LINE__);
        }
        $this->strAddress = $strAddress;
        return $this;
    }
    /**
     * Get strRegion value
     * @return string|null
     */
    public function getStrRegion()
    {
        return $this->strRegion;
    }
    /**
     * Set strRegion value
     * @param string $strRegion
     * @return \StructType\LastPacket
     */
    public function setStrRegion($strRegion = null)
    {
        // validation for constraint: string
        if (!is_null($strRegion) && !is_string($strRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strRegion, true), gettype($strRegion)), __LINE__);
        }
        $this->strRegion = $strRegion;
        return $this;
    }
}
