<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DriverInformation StructType
 * @subpackage Structs
 */
class DriverInformation extends AbstractStructBase
{
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The PIN1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN1;
    /**
     * The PIN2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN2;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The Node
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Node;
    /**
     * The Plate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Plate;
    /**
     * Constructor method for DriverInformation
     * @uses DriverInformation::setUsername()
     * @uses DriverInformation::setPIN1()
     * @uses DriverInformation::setPIN2()
     * @uses DriverInformation::setStartDate()
     * @uses DriverInformation::setNode()
     * @uses DriverInformation::setPlate()
     * @param string $username
     * @param string $pIN1
     * @param string $pIN2
     * @param string $startDate
     * @param string $node
     * @param string $plate
     */
    public function __construct($username = null, $pIN1 = null, $pIN2 = null, $startDate = null, $node = null, $plate = null)
    {
        $this
            ->setUsername($username)
            ->setPIN1($pIN1)
            ->setPIN2($pIN2)
            ->setStartDate($startDate)
            ->setNode($node)
            ->setPlate($plate);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\DriverInformation
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get PIN1 value
     * @return string|null
     */
    public function getPIN1()
    {
        return $this->PIN1;
    }
    /**
     * Set PIN1 value
     * @param string $pIN1
     * @return \StructType\DriverInformation
     */
    public function setPIN1($pIN1 = null)
    {
        // validation for constraint: string
        if (!is_null($pIN1) && !is_string($pIN1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN1, true), gettype($pIN1)), __LINE__);
        }
        $this->PIN1 = $pIN1;
        return $this;
    }
    /**
     * Get PIN2 value
     * @return string|null
     */
    public function getPIN2()
    {
        return $this->PIN2;
    }
    /**
     * Set PIN2 value
     * @param string $pIN2
     * @return \StructType\DriverInformation
     */
    public function setPIN2($pIN2 = null)
    {
        // validation for constraint: string
        if (!is_null($pIN2) && !is_string($pIN2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN2, true), gettype($pIN2)), __LINE__);
        }
        $this->PIN2 = $pIN2;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\DriverInformation
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get Node value
     * @return string|null
     */
    public function getNode()
    {
        return $this->Node;
    }
    /**
     * Set Node value
     * @param string $node
     * @return \StructType\DriverInformation
     */
    public function setNode($node = null)
    {
        // validation for constraint: string
        if (!is_null($node) && !is_string($node)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($node, true), gettype($node)), __LINE__);
        }
        $this->Node = $node;
        return $this;
    }
    /**
     * Get Plate value
     * @return string|null
     */
    public function getPlate()
    {
        return $this->Plate;
    }
    /**
     * Set Plate value
     * @param string $plate
     * @return \StructType\DriverInformation
     */
    public function setPlate($plate = null)
    {
        // validation for constraint: string
        if (!is_null($plate) && !is_string($plate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plate, true), gettype($plate)), __LINE__);
        }
        $this->Plate = $plate;
        return $this;
    }
}
