<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Building ServiceType
 * @subpackage Services
 */
class Building extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BuildingListReport
     * Meta information extracted from the WSDL
     * - documentation: Tanimli Bina/bolge listesini olusturur. - Creates a list of defined buildings / zones. | Tanimli Bina/bolge listesini olusturur. - Creates a list of defined buildings / zones. | Tanimli Bina/bolge listesini olusturur. - Creates a
     * list of defined buildings / zones.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BuildingListReport $parameters
     * @return \StructType\BuildingListReportResponse|bool
     */
    public function BuildingListReport(\StructType\BuildingListReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BuildingListReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BuildingListReportReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Tanimli Bina/bolge listesini olusturur. BuildingListReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates a list of defined buildings / zones, returns the result as XmlDocument type. | Tanimli Bina/bolge
     * listesini olusturur. BuildingListReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates a list of defined buildings / zones, returns the result as XmlDocument type. | Tanimli Bina/bolge listesini olusturur. BuildingListReport
     * methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates a list of defined buildings / zones, returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BuildingListReportReturnObject $parameters
     * @return \StructType\BuildingListReportReturnObjectResponse|bool
     */
    public function BuildingListReportReturnObject(\StructType\BuildingListReportReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BuildingListReportReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BuildingListReportResponse|\StructType\BuildingListReportReturnObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
