<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Vehicle ServiceType
 * @subpackage Services
 */
class Vehicle extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VehicleProgramReport
     * Meta information extracted from the WSDL
     * - documentation: Arac program durumu raporunu olusturur. Cihazin uzerinde bulunan program ( konfigurasyon ) durumlari listelenir. chkAllVehicles '1' olarak girilirse kayitli tum araclarin program durumlarini listeler Node alanini doldurmaya gerek
     * kalmaz. - It generates vehicle program status report. The program (configuration) statuses on the device are listed. If chkAllVehicles is set to '1', it lists the program states of all registered vehicles. There is no need to fill the Node field. |
     * Arac program durumu raporunu olusturur. Cihazin uzerinde bulunan program ( konfigurasyon ) durumlari listelenir. chkAllVehicles '1' olarak girilirse kayitli tum araclarin program durumlarini listeler Node alanini doldurmaya gerek kalmaz. - It
     * generates vehicle program status report. The program (configuration) statuses on the device are listed. If chkAllVehicles is set to '1', it lists the program states of all registered vehicles. There is no need to fill the Node field. | Arac program
     * durumu raporunu olusturur. Cihazin uzerinde bulunan program ( konfigurasyon ) durumlari listelenir. chkAllVehicles '1' olarak girilirse kayitli tum araclarin program durumlarini listeler Node alanini doldurmaya gerek kalmaz. - It generates vehicle
     * program status report. The program (configuration) statuses on the device are listed. If chkAllVehicles is set to '1', it lists the program states of all registered vehicles. There is no need to fill the Node field.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleProgramReport $parameters
     * @return \StructType\VehicleProgramReportResponse|bool
     */
    public function VehicleProgramReport(\StructType\VehicleProgramReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleProgramReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleProgramReportReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Arac program durumu raporunu olusturur. Cihazin uzerinde bulunan program ( konfigurasyon ) durumlari listelenir. chkAllVehicles '1' olarak girilirse kayitli tum araclarin program durumlarini listeler Node alanini doldurmaya gerek
     * kalmaz. VehicleProgramReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It generates vehicle program status report. The program (configuration) statuses on the device are listed. If chkAllVehicles is set to '1', it lists the
     * program states of all registered vehicles. There is no need to fill the Node field, returns the result as XmlDocument type. | Arac program durumu raporunu olusturur. Cihazin uzerinde bulunan program ( konfigurasyon ) durumlari listelenir.
     * chkAllVehicles '1' olarak girilirse kayitli tum araclarin program durumlarini listeler Node alanini doldurmaya gerek kalmaz. VehicleProgramReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It generates vehicle program status
     * report. The program (configuration) statuses on the device are listed. If chkAllVehicles is set to '1', it lists the program states of all registered vehicles. There is no need to fill the Node field, returns the result as XmlDocument type. | Arac
     * program durumu raporunu olusturur. Cihazin uzerinde bulunan program ( konfigurasyon ) durumlari listelenir. chkAllVehicles '1' olarak girilirse kayitli tum araclarin program durumlarini listeler Node alanini doldurmaya gerek kalmaz.
     * VehicleProgramReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It generates vehicle program status report. The program (configuration) statuses on the device are listed. If chkAllVehicles is set to '1', it lists the program
     * states of all registered vehicles. There is no need to fill the Node field, returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleProgramReportReturnObject $parameters
     * @return \StructType\VehicleProgramReportReturnObjectResponse|bool
     */
    public function VehicleProgramReportReturnObject(\StructType\VehicleProgramReportReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleProgramReportReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleOperatingReport
     * Meta information extracted from the WSDL
     * - documentation: Arac calisma raporunu olusturur. Arac calisma raporu, cihazdan gelen verilerin yorumlanmasi sonucu ozet olarak sunulan rapordur. Show ile baslayan parametre degerleri true veya false olarak girilmelidir. Butun parametre degerlerinin
     * doldurulmasi zorunludur. - Creates a vehicle operating report. The vehicle operating report is a summary of the data received from the device. Parameter values that start with Show should be entered as true or false. It is necessary to fill in all
     * parameter values. | Arac calisma raporunu olusturur. Arac calisma raporu, cihazdan gelen verilerin yorumlanmasi sonucu ozet olarak sunulan rapordur. Show ile baslayan parametre degerleri true veya false olarak girilmelidir. Butun parametre
     * degerlerinin doldurulmasi zorunludur. - Creates a vehicle operating report. The vehicle operating report is a summary of the data received from the device. Parameter values that start with Show should be entered as true or false. It is necessary to
     * fill in all parameter values. | Arac calisma raporunu olusturur. Arac calisma raporu, cihazdan gelen verilerin yorumlanmasi sonucu ozet olarak sunulan rapordur. Show ile baslayan parametre degerleri true veya false olarak girilmelidir. Butun
     * parametre degerlerinin doldurulmasi zorunludur. - Creates a vehicle operating report. The vehicle operating report is a summary of the data received from the device. Parameter values that start with Show should be entered as true or false. It is
     * necessary to fill in all parameter values.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleOperatingReport $parameters
     * @return \StructType\VehicleOperatingReportResponse|bool
     */
    public function VehicleOperatingReport(\StructType\VehicleOperatingReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleOperatingReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleOperatingReportReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Arac calisma raporunu olusturur. Arac calisma raporu, cihazdan gelen verilerin yorumlanmasi sonucu ozet olarak sunulan rapordur. Show ile baslayan parametre degerleri true veya false olarak girilmelidir. Butun parametre degerlerinin
     * doldurulmasi zorunludur. VehicleOperatingReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates a vehicle operating report. The vehicle operating report is a summary of the data received from the device. Parameter values that
     * start with Show should be entered as true or false. It is necessary to fill in all parameter values, returns the result as XmlDocument type. | Arac calisma raporunu olusturur. Arac calisma raporu, cihazdan gelen verilerin yorumlanmasi sonucu ozet
     * olarak sunulan rapordur. Show ile baslayan parametre degerleri true veya false olarak girilmelidir. Butun parametre degerlerinin doldurulmasi zorunludur. VehicleOperatingReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates
     * a vehicle operating report. The vehicle operating report is a summary of the data received from the device. Parameter values that start with Show should be entered as true or false. It is necessary to fill in all parameter values, returns the result
     * as XmlDocument type. | Arac calisma raporunu olusturur. Arac calisma raporu, cihazdan gelen verilerin yorumlanmasi sonucu ozet olarak sunulan rapordur. Show ile baslayan parametre degerleri true veya false olarak girilmelidir. Butun parametre
     * degerlerinin doldurulmasi zorunludur. VehicleOperatingReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates a vehicle operating report. The vehicle operating report is a summary of the data received from the device.
     * Parameter values that start with Show should be entered as true or false. It is necessary to fill in all parameter values, returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleOperatingReportReturnObject $parameters
     * @return \StructType\VehicleOperatingReportReturnObjectResponse|bool
     */
    public function VehicleOperatingReportReturnObject(\StructType\VehicleOperatingReportReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleOperatingReportReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleOperatingReport2
     * Meta information extracted from the WSDL
     * - documentation: Arac calisma raporunu olusturur. Arac calisma raporu, cihazdan gelen verilerin yorumlanmasi sonucu ozet olarak sunulan rapordur. Show ile baslayan parametre degerleri true veya false olarak girilmelidir. Butun parametre degerlerinin
     * doldurulmasi zorunludur. - Creates a vehicle operating report. The vehicle operating report is a summary of the data received from the device. Parameter values that start with Show should be entered as true or false. It is necessary to fill in all
     * parameter values. | Arac calisma raporunu olusturur. Arac calisma raporu, cihazdan gelen verilerin yorumlanmasi sonucu ozet olarak sunulan rapordur. Show ile baslayan parametre degerleri true veya false olarak girilmelidir. Butun parametre
     * degerlerinin doldurulmasi zorunludur. - Creates a vehicle operating report. The vehicle operating report is a summary of the data received from the device. Parameter values that start with Show should be entered as true or false. It is necessary to
     * fill in all parameter values. | Arac calisma raporunu olusturur. Arac calisma raporu, cihazdan gelen verilerin yorumlanmasi sonucu ozet olarak sunulan rapordur. Show ile baslayan parametre degerleri true veya false olarak girilmelidir. Butun
     * parametre degerlerinin doldurulmasi zorunludur. - Creates a vehicle operating report. The vehicle operating report is a summary of the data received from the device. Parameter values that start with Show should be entered as true or false. It is
     * necessary to fill in all parameter values.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleOperatingReport2 $parameters
     * @return \StructType\VehicleOperatingReport2Response|bool
     */
    public function VehicleOperatingReport2(\StructType\VehicleOperatingReport2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleOperatingReport2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * VehicleOperatingReport2ReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Arac calisma raporunu olusturur. Arac calisma raporu, cihazdan gelen verilerin yorumlanmasi sonucu ozet olarak sunulan rapordur. Show ile baslayan parametre degerleri true veya false olarak girilmelidir. Butun parametre degerlerinin
     * doldurulmasi zorunludur. GeneralReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates a vehicle operating report. The vehicle operating report is a summary of the data received from the device. Parameter values that start
     * with Show should be entered as true or false. It is necessary to fill in all parameter values, returns the result as XmlDocument type. | Arac calisma raporunu olusturur. Arac calisma raporu, cihazdan gelen verilerin yorumlanmasi sonucu ozet olarak
     * sunulan rapordur. Show ile baslayan parametre degerleri true veya false olarak girilmelidir. Butun parametre degerlerinin doldurulmasi zorunludur. GeneralReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates a vehicle
     * operating report. The vehicle operating report is a summary of the data received from the device. Parameter values that start with Show should be entered as true or false. It is necessary to fill in all parameter values, returns the result as
     * XmlDocument type. | Arac calisma raporunu olusturur. Arac calisma raporu, cihazdan gelen verilerin yorumlanmasi sonucu ozet olarak sunulan rapordur. Show ile baslayan parametre degerleri true veya false olarak girilmelidir. Butun parametre
     * degerlerinin doldurulmasi zorunludur. GeneralReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates a vehicle operating report. The vehicle operating report is a summary of the data received from the device. Parameter values
     * that start with Show should be entered as true or false. It is necessary to fill in all parameter values, returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleOperatingReport2ReturnObject $parameters
     * @return \StructType\VehicleOperatingReport2ReturnObjectResponse|bool
     */
    public function VehicleOperatingReport2ReturnObject(\StructType\VehicleOperatingReport2ReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleOperatingReport2ReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleDistanceReport
     * Meta information extracted from the WSDL
     * - documentation: Arac mesafe raporunu olusturur. Mesafe, aracin belli zaman araliklarinda aldigi yoldur. Bu metot ile aracin GPS odometre (mesafe sayaci) degerlerindeki degisim raporlanir. - Creates a vehicle distance report. This method reports the
     * change in the vehicle's GPS odometer values. | Arac mesafe raporunu olusturur. Mesafe, aracin belli zaman araliklarinda aldigi yoldur. Bu metot ile aracin GPS odometre (mesafe sayaci) degerlerindeki degisim raporlanir. - Creates a vehicle distance
     * report. This method reports the change in the vehicle's GPS odometer values. | Arac mesafe raporunu olusturur. Mesafe, aracin belli zaman araliklarinda aldigi yoldur. Bu metot ile aracin GPS odometre (mesafe sayaci) degerlerindeki degisim raporlanir.
     * - Creates a vehicle distance report. This method reports the change in the vehicle's GPS odometer values.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleDistanceReport $parameters
     * @return \StructType\VehicleDistanceReportResponse|bool
     */
    public function VehicleDistanceReport(\StructType\VehicleDistanceReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleDistanceReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleDistanceReportReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Arac mesafe raporunu olusturur. Mesafe, aracin belli zaman araliklarinda aldigi yoldur. Bu metot ile aracin GPS odometre (mesafe sayaci) degerlerindeki degisim raporlanir. VehicleDistanceReport methodundan farkli olarak sonucu
     * XmlDocument tipinde dondurur. - Creates a vehicle distance report. This method reports the change in the vehicle's GPS odometer values, returns the result as XmlDocument type. | Arac mesafe raporunu olusturur. Mesafe, aracin belli zaman araliklarinda
     * aldigi yoldur. Bu metot ile aracin GPS odometre (mesafe sayaci) degerlerindeki degisim raporlanir. VehicleDistanceReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates a vehicle distance report. This method reports the
     * change in the vehicle's GPS odometer values, returns the result as XmlDocument type. | Arac mesafe raporunu olusturur. Mesafe, aracin belli zaman araliklarinda aldigi yoldur. Bu metot ile aracin GPS odometre (mesafe sayaci) degerlerindeki degisim
     * raporlanir. VehicleDistanceReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates a vehicle distance report. This method reports the change in the vehicle's GPS odometer values, returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleDistanceReportReturnObject $parameters
     * @return \StructType\VehicleDistanceReportReturnObjectResponse|bool
     */
    public function VehicleDistanceReportReturnObject(\StructType\VehicleDistanceReportReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleDistanceReportReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleDistanceReport2
     * Meta information extracted from the WSDL
     * - documentation: Arac mesafe raporunu olusturur. Mesafe, aracin belli zaman araliklarinda aldigi yoldur. Bu metot ile aracin GPS odometre(mesafe sayaci) degerlerindeki degisim raporlanir. - Creates a vehicle distance report. This method reports the
     * change in the vehicle's GPS odometer values. | Arac mesafe raporunu olusturur. Mesafe, aracin belli zaman araliklarinda aldigi yoldur. Bu metot ile aracin GPS odometre(mesafe sayaci) degerlerindeki degisim raporlanir. - Creates a vehicle distance
     * report. This method reports the change in the vehicle's GPS odometer values. | Arac mesafe raporunu olusturur. Mesafe, aracin belli zaman araliklarinda aldigi yoldur. Bu metot ile aracin GPS odometre(mesafe sayaci) degerlerindeki degisim raporlanir.
     * - Creates a vehicle distance report. This method reports the change in the vehicle's GPS odometer values.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleDistanceReport2 $parameters
     * @return \StructType\VehicleDistanceReport2Response|bool
     */
    public function VehicleDistanceReport2(\StructType\VehicleDistanceReport2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleDistanceReport2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleDistanceReport2ReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Arac mesafe raporunu olusturur. Mesafe, aracin belli zaman araliklarinda aldigi yoldur. Bu metot ile aracin GPS odometre(mesafe sayaci) degerlerindeki degisim raporlanir. VehicleDistanceReport2 methodundan farkli olarak sonucu
     * XmlDocument tipinde dondurur. - Creates a vehicle distance report. This method reports the change in the vehicle's GPS odometer values, returns the result as XmlDocument type | Arac mesafe raporunu olusturur. Mesafe, aracin belli zaman araliklarinda
     * aldigi yoldur. Bu metot ile aracin GPS odometre(mesafe sayaci) degerlerindeki degisim raporlanir. VehicleDistanceReport2 methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates a vehicle distance report. This method reports the
     * change in the vehicle's GPS odometer values, returns the result as XmlDocument type | Arac mesafe raporunu olusturur. Mesafe, aracin belli zaman araliklarinda aldigi yoldur. Bu metot ile aracin GPS odometre(mesafe sayaci) degerlerindeki degisim
     * raporlanir. VehicleDistanceReport2 methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Creates a vehicle distance report. This method reports the change in the vehicle's GPS odometer values, returns the result as XmlDocument type
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleDistanceReport2ReturnObject $parameters
     * @return \StructType\VehicleDistanceReport2ReturnObjectResponse|bool
     */
    public function VehicleDistanceReport2ReturnObject(\StructType\VehicleDistanceReport2ReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleDistanceReport2ReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleLastStateReport
     * Meta information extracted from the WSDL
     * - documentation: Cihazdan gelen son bilgileri istenilen tarihle 1 gun sonrasi icin listeler. - The last data from the device lists between the selected day and after 1 day. | Cihazdan gelen son bilgileri istenilen tarihle 1 gun sonrasi icin listeler.
     * - The last data from the device lists between the selected day and after 1 day. | Cihazdan gelen son bilgileri istenilen tarihle 1 gun sonrasi icin listeler. - The last data from the device lists between the selected day and after 1 day.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleLastStateReport $parameters
     * @return \StructType\VehicleLastStateReportResponse|bool
     */
    public function VehicleLastStateReport(\StructType\VehicleLastStateReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleLastStateReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleLastStateReportReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Cihazdan gelen son bilgileri istenilen tarihle 1 gun sonrasi icin listeler. VehicleLastStateReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - The last data from the device lists between the selected day and
     * after 1 day, returns the result as XmlDocument type. | Cihazdan gelen son bilgileri istenilen tarihle 1 gun sonrasi icin listeler. VehicleLastStateReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - The last data from the device
     * lists between the selected day and after 1 day, returns the result as XmlDocument type. | Cihazdan gelen son bilgileri istenilen tarihle 1 gun sonrasi icin listeler. VehicleLastStateReport methodundan farkli olarak sonucu XmlDocument tipinde
     * dondurur. - The last data from the device lists between the selected day and after 1 day, returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleLastStateReportReturnObject $parameters
     * @return \StructType\VehicleLastStateReportReturnObjectResponse|bool
     */
    public function VehicleLastStateReportReturnObject(\StructType\VehicleLastStateReportReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleLastStateReportReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleLastStateReport2
     * Meta information extracted from the WSDL
     * - documentation: Cihazdan gelen son verileri istenilen gun icin listeler. - Lists last data from the device for the selected day. | Cihazdan gelen son verileri istenilen gun icin listeler. - Lists last data from the device for the selected day. |
     * Cihazdan gelen son verileri istenilen gun icin listeler. - Lists last data from the device for the selected day.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleLastStateReport2 $parameters
     * @return \StructType\VehicleLastStateReport2Response|bool
     */
    public function VehicleLastStateReport2(\StructType\VehicleLastStateReport2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleLastStateReport2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * VehicleLastStateReport2ReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Cihazdan gelen son verileri istenilen gun icin listeler. GeneralReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Lists last data from the device for the selected day, returns the result as XmlDocument type. |
     * Cihazdan gelen son verileri istenilen gun icin listeler. GeneralReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Lists last data from the device for the selected day, returns the result as XmlDocument type. | Cihazdan gelen son
     * verileri istenilen gun icin listeler. GeneralReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Lists last data from the device for the selected day, returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleLastStateReport2ReturnObject $parameters
     * @return \StructType\VehicleLastStateReport2ReturnObjectResponse|bool
     */
    public function VehicleLastStateReport2ReturnObject(\StructType\VehicleLastStateReport2ReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleLastStateReport2ReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleDailyStatusReport
     * Meta information extracted from the WSDL
     * - documentation: Araclarin son konum bilgisini ve günlük mesafelerini gosterir. JSON formatinda doner. - Shows the last position information and daily trip of the vehicles. Returns in JSON format. | Araclarin son konum bilgisini ve günlük
     * mesafelerini gosterir. JSON formatinda doner. - Shows the last position information and daily trip of the vehicles. Returns in JSON format. | Araclarin son konum bilgisini ve günlük mesafelerini gosterir. JSON formatinda doner. - Shows the last
     * position information and daily trip of the vehicles. Returns in JSON format.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleDailyStatusReport $parameters
     * @return \StructType\VehicleDailyStatusReportResponse|bool
     */
    public function VehicleDailyStatusReport(\StructType\VehicleDailyStatusReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VehicleDailyStatusReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VehicleDailyStatusReportResponse|\StructType\VehicleDistanceReport2Response|\StructType\VehicleDistanceReport2ReturnObjectResponse|\StructType\VehicleDistanceReportResponse|\StructType\VehicleDistanceReportReturnObjectResponse|\StructType\VehicleLastStateReport2Response|\StructType\VehicleLastStateReport2ReturnObjectResponse|\StructType\VehicleLastStateReportResponse|\StructType\VehicleLastStateReportReturnObjectResponse|\StructType\VehicleOperatingReport2Response|\StructType\VehicleOperatingReport2ReturnObjectResponse|\StructType\VehicleOperatingReportResponse|\StructType\VehicleOperatingReportReturnObjectResponse|\StructType\VehicleProgramReportResponse|\StructType\VehicleProgramReportReturnObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
