<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://servicoshm.saude.gov.br/cnes/EstabelecimentoSaudeService/v1r0?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://servicoshm.saude.gov.br/cnes/EstabelecimentoSaudeService/v1r0?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Consultar ServiceType
 */
$consultar = new \ServiceType\Consultar($options);
/**
 * Sample call for consultarEstabelecimentoSaude operation/method
 */
if ($consultar->consultarEstabelecimentoSaude(new \StructType\RequestConsultarEstabelecimentoSaude()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for consultarPrecadastroCNES operation/method
 */
if ($consultar->consultarPrecadastroCNES(new \StructType\RequestConsultarPrecadastroCNES()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Samples for Localizar ServiceType
 */
$localizar = new \ServiceType\Localizar($options);
/**
 * Sample call for localizarEstabelecimentoSaude operation/method
 */
if ($localizar->localizarEstabelecimentoSaude(new \StructType\RequestLocalizarEstabelecimentoSaude()) !== false) {
    print_r($localizar->getResult());
} else {
    print_r($localizar->getLastError());
}
