<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelefoneType StructType
 * @subpackage Structs
 */
class TelefoneType extends AbstractStructBase
{
    /**
     * The identificador
     * Meta informations extracted from the WSDL
     * - documentation: Código de identificação.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $identificador;
    /**
     * The TipoTelefone
     * Meta informations extracted from the WSDL
     * - documentation: Tipo de telefone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TipoTelefoneType
     */
    public $TipoTelefone;
    /**
     * The DDI
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: DDI do telefone.
     * - maxInclusive: 999
     * @var int
     */
    public $DDI;
    /**
     * The DDD
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: DDD do telefone.
     * - maxInclusive: 99
     * @var int
     */
    public $DDD;
    /**
     * The numeroTelefone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Numero do telefone.
     * - maxInclusive: 999999999
     * @var int
     */
    public $numeroTelefone;
    /**
     * Constructor method for TelefoneType
     * @uses TelefoneType::setIdentificador()
     * @uses TelefoneType::setTipoTelefone()
     * @uses TelefoneType::setDDI()
     * @uses TelefoneType::setDDD()
     * @uses TelefoneType::setNumeroTelefone()
     * @param int $identificador
     * @param \StructType\TipoTelefoneType $tipoTelefone
     * @param int $dDI
     * @param int $dDD
     * @param int $numeroTelefone
     */
    public function __construct($identificador = null, \StructType\TipoTelefoneType $tipoTelefone = null, $dDI = null, $dDD = null, $numeroTelefone = null)
    {
        $this
            ->setIdentificador($identificador)
            ->setTipoTelefone($tipoTelefone)
            ->setDDI($dDI)
            ->setDDD($dDD)
            ->setNumeroTelefone($numeroTelefone);
    }
    /**
     * Get identificador value
     * @return int|null
     */
    public function getIdentificador()
    {
        return $this->identificador;
    }
    /**
     * Set identificador value
     * @param int $identificador
     * @return \StructType\TelefoneType
     */
    public function setIdentificador($identificador = null)
    {
        // validation for constraint: int
        if (!is_null($identificador) && !is_numeric($identificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($identificador)), __LINE__);
        }
        $this->identificador = $identificador;
        return $this;
    }
    /**
     * Get TipoTelefone value
     * @return \StructType\TipoTelefoneType|null
     */
    public function getTipoTelefone()
    {
        return $this->TipoTelefone;
    }
    /**
     * Set TipoTelefone value
     * @param \StructType\TipoTelefoneType $tipoTelefone
     * @return \StructType\TelefoneType
     */
    public function setTipoTelefone(\StructType\TipoTelefoneType $tipoTelefone = null)
    {
        $this->TipoTelefone = $tipoTelefone;
        return $this;
    }
    /**
     * Get DDI value
     * @return int|null
     */
    public function getDDI()
    {
        return $this->DDI;
    }
    /**
     * Set DDI value
     * @param int $dDI
     * @return \StructType\TelefoneType
     */
    public function setDDI($dDI = null)
    {
        // validation for constraint: int
        if (!is_null($dDI) && !is_numeric($dDI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dDI)), __LINE__);
        }
        $this->DDI = $dDI;
        return $this;
    }
    /**
     * Get DDD value
     * @return int|null
     */
    public function getDDD()
    {
        return $this->DDD;
    }
    /**
     * Set DDD value
     * @param int $dDD
     * @return \StructType\TelefoneType
     */
    public function setDDD($dDD = null)
    {
        // validation for constraint: int
        if (!is_null($dDD) && !is_numeric($dDD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dDD)), __LINE__);
        }
        $this->DDD = $dDD;
        return $this;
    }
    /**
     * Get numeroTelefone value
     * @return int|null
     */
    public function getNumeroTelefone()
    {
        return $this->numeroTelefone;
    }
    /**
     * Set numeroTelefone value
     * @param int $numeroTelefone
     * @return \StructType\TelefoneType
     */
    public function setNumeroTelefone($numeroTelefone = null)
    {
        // validation for constraint: int
        if (!is_null($numeroTelefone) && !is_numeric($numeroTelefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroTelefone)), __LINE__);
        }
        $this->numeroTelefone = $numeroTelefone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TelefoneType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
