<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NomeJuridicoType StructType
 * @subpackage Structs
 */
class NomeJuridicoType extends AbstractStructBase
{
    /**
     * The Nome
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Nomes atribuidos da pessoa jurídica (Empresarial e Fantasia). | Nomes atribuidos da pessoa fisica.
     * - maxLength: 70
     * @var string
     */
    public $Nome;
    /**
     * Constructor method for NomeJuridicoType
     * @uses NomeJuridicoType::setNome()
     * @param string $nome
     */
    public function __construct($nome = null)
    {
        $this
            ->setNome($nome);
    }
    /**
     * Get Nome value
     * @return string
     */
    public function getNome()
    {
        return $this->Nome;
    }
    /**
     * Set Nome value
     * @param string $nome
     * @return \StructType\NomeJuridicoType
     */
    public function setNome($nome = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nome) && strlen($nome) > 70) || (is_array($nome) && count($nome) > 70)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 70 element(s) or a scalar of 70 character(s) at most, "%d" length given', is_scalar($nome) ? strlen($nome) : count($nome)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nome)), __LINE__);
        }
        $this->Nome = $nome;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NomeJuridicoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
