<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DadosGeraisEstabelecimentoSaudeType StructType
 * @subpackage Structs
 */
class DadosGeraisEstabelecimentoSaudeType extends AbstractStructBase
{
    /**
     * The CodigoCNES
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: cocnes:CodigoCNES
     * @var \StructType\CodigoCNESType
     */
    public $CodigoCNES;
    /**
     * The CodigoUnidade
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: counidade:CodigoUnidade
     * @var \StructType\CodigoUnidadeType
     */
    public $CodigoUnidade;
    /**
     * The nomeFantasia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NomeJuridicoType
     */
    public $nomeFantasia;
    /**
     * The nomeEmpresarial
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NomeJuridicoType
     */
    public $nomeEmpresarial;
    /**
     * The CNPJ
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: cnpj:CNPJ
     * @var \StructType\CNPJType
     */
    public $CNPJ;
    /**
     * The Endereco
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: endereco:Endereco
     * @var \StructType\EnderecoType
     */
    public $Endereco;
    /**
     * The dataAtualizacao
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataAtualizacao;
    /**
     * The Diretor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: diretor:Diretor
     * @var \StructType\DiretorType
     */
    public $Diretor;
    /**
     * The tipoUnidade
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tipounidade:tipoUnidade
     * @var \StructType\TipoUnidadeType
     */
    public $tipoUnidade;
    /**
     * The esferaAdministrativa
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: esferaadm:esferaAdministrativa
     * @var \StructType\EsferaAdministrativaType
     */
    public $esferaAdministrativa;
    /**
     * The MunicipioGestor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MunicipioType
     */
    public $MunicipioGestor;
    /**
     * The Telefone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\TelefoneType[]
     */
    public $Telefone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EmailType
     */
    public $Email;
    /**
     * The Localizacao
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LocalizacaoType
     */
    public $Localizacao;
    /**
     * The perteceSistemaSUS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $perteceSistemaSUS;
    /**
     * Constructor method for DadosGeraisEstabelecimentoSaudeType
     * @uses DadosGeraisEstabelecimentoSaudeType::setCodigoCNES()
     * @uses DadosGeraisEstabelecimentoSaudeType::setCodigoUnidade()
     * @uses DadosGeraisEstabelecimentoSaudeType::setNomeFantasia()
     * @uses DadosGeraisEstabelecimentoSaudeType::setNomeEmpresarial()
     * @uses DadosGeraisEstabelecimentoSaudeType::setCNPJ()
     * @uses DadosGeraisEstabelecimentoSaudeType::setEndereco()
     * @uses DadosGeraisEstabelecimentoSaudeType::setDataAtualizacao()
     * @uses DadosGeraisEstabelecimentoSaudeType::setDiretor()
     * @uses DadosGeraisEstabelecimentoSaudeType::setTipoUnidade()
     * @uses DadosGeraisEstabelecimentoSaudeType::setEsferaAdministrativa()
     * @uses DadosGeraisEstabelecimentoSaudeType::setMunicipioGestor()
     * @uses DadosGeraisEstabelecimentoSaudeType::setTelefone()
     * @uses DadosGeraisEstabelecimentoSaudeType::setEmail()
     * @uses DadosGeraisEstabelecimentoSaudeType::setLocalizacao()
     * @uses DadosGeraisEstabelecimentoSaudeType::setPerteceSistemaSUS()
     * @param \StructType\CodigoCNESType $codigoCNES
     * @param \StructType\CodigoUnidadeType $codigoUnidade
     * @param \StructType\NomeJuridicoType $nomeFantasia
     * @param \StructType\NomeJuridicoType $nomeEmpresarial
     * @param \StructType\CNPJType $cNPJ
     * @param \StructType\EnderecoType $endereco
     * @param string $dataAtualizacao
     * @param \StructType\DiretorType $diretor
     * @param \StructType\TipoUnidadeType $tipoUnidade
     * @param \StructType\EsferaAdministrativaType $esferaAdministrativa
     * @param \StructType\MunicipioType $municipioGestor
     * @param \StructType\TelefoneType[] $telefone
     * @param \StructType\EmailType $email
     * @param \StructType\LocalizacaoType $localizacao
     * @param bool $perteceSistemaSUS
     */
    public function __construct(\StructType\CodigoCNESType $codigoCNES = null, \StructType\CodigoUnidadeType $codigoUnidade = null, \StructType\NomeJuridicoType $nomeFantasia = null, \StructType\NomeJuridicoType $nomeEmpresarial = null, \StructType\CNPJType $cNPJ = null, \StructType\EnderecoType $endereco = null, $dataAtualizacao = null, \StructType\DiretorType $diretor = null, \StructType\TipoUnidadeType $tipoUnidade = null, \StructType\EsferaAdministrativaType $esferaAdministrativa = null, \StructType\MunicipioType $municipioGestor = null, array $telefone = array(), \StructType\EmailType $email = null, \StructType\LocalizacaoType $localizacao = null, $perteceSistemaSUS = null)
    {
        $this
            ->setCodigoCNES($codigoCNES)
            ->setCodigoUnidade($codigoUnidade)
            ->setNomeFantasia($nomeFantasia)
            ->setNomeEmpresarial($nomeEmpresarial)
            ->setCNPJ($cNPJ)
            ->setEndereco($endereco)
            ->setDataAtualizacao($dataAtualizacao)
            ->setDiretor($diretor)
            ->setTipoUnidade($tipoUnidade)
            ->setEsferaAdministrativa($esferaAdministrativa)
            ->setMunicipioGestor($municipioGestor)
            ->setTelefone($telefone)
            ->setEmail($email)
            ->setLocalizacao($localizacao)
            ->setPerteceSistemaSUS($perteceSistemaSUS);
    }
    /**
     * Get CodigoCNES value
     * @return \StructType\CodigoCNESType|null
     */
    public function getCodigoCNES()
    {
        return $this->CodigoCNES;
    }
    /**
     * Set CodigoCNES value
     * @param \StructType\CodigoCNESType $codigoCNES
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setCodigoCNES(\StructType\CodigoCNESType $codigoCNES = null)
    {
        $this->CodigoCNES = $codigoCNES;
        return $this;
    }
    /**
     * Get CodigoUnidade value
     * @return \StructType\CodigoUnidadeType|null
     */
    public function getCodigoUnidade()
    {
        return $this->CodigoUnidade;
    }
    /**
     * Set CodigoUnidade value
     * @param \StructType\CodigoUnidadeType $codigoUnidade
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setCodigoUnidade(\StructType\CodigoUnidadeType $codigoUnidade = null)
    {
        $this->CodigoUnidade = $codigoUnidade;
        return $this;
    }
    /**
     * Get nomeFantasia value
     * @return \StructType\NomeJuridicoType|null
     */
    public function getNomeFantasia()
    {
        return $this->nomeFantasia;
    }
    /**
     * Set nomeFantasia value
     * @param \StructType\NomeJuridicoType $nomeFantasia
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setNomeFantasia(\StructType\NomeJuridicoType $nomeFantasia = null)
    {
        $this->nomeFantasia = $nomeFantasia;
        return $this;
    }
    /**
     * Get nomeEmpresarial value
     * @return \StructType\NomeJuridicoType|null
     */
    public function getNomeEmpresarial()
    {
        return $this->nomeEmpresarial;
    }
    /**
     * Set nomeEmpresarial value
     * @param \StructType\NomeJuridicoType $nomeEmpresarial
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setNomeEmpresarial(\StructType\NomeJuridicoType $nomeEmpresarial = null)
    {
        $this->nomeEmpresarial = $nomeEmpresarial;
        return $this;
    }
    /**
     * Get CNPJ value
     * @return \StructType\CNPJType|null
     */
    public function getCNPJ()
    {
        return $this->CNPJ;
    }
    /**
     * Set CNPJ value
     * @param \StructType\CNPJType $cNPJ
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setCNPJ(\StructType\CNPJType $cNPJ = null)
    {
        $this->CNPJ = $cNPJ;
        return $this;
    }
    /**
     * Get Endereco value
     * @return \StructType\EnderecoType|null
     */
    public function getEndereco()
    {
        return $this->Endereco;
    }
    /**
     * Set Endereco value
     * @param \StructType\EnderecoType $endereco
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setEndereco(\StructType\EnderecoType $endereco = null)
    {
        $this->Endereco = $endereco;
        return $this;
    }
    /**
     * Get dataAtualizacao value
     * @return string|null
     */
    public function getDataAtualizacao()
    {
        return $this->dataAtualizacao;
    }
    /**
     * Set dataAtualizacao value
     * @param string $dataAtualizacao
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setDataAtualizacao($dataAtualizacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataAtualizacao) && !is_string($dataAtualizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataAtualizacao)), __LINE__);
        }
        $this->dataAtualizacao = $dataAtualizacao;
        return $this;
    }
    /**
     * Get Diretor value
     * @return \StructType\DiretorType|null
     */
    public function getDiretor()
    {
        return $this->Diretor;
    }
    /**
     * Set Diretor value
     * @param \StructType\DiretorType $diretor
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setDiretor(\StructType\DiretorType $diretor = null)
    {
        $this->Diretor = $diretor;
        return $this;
    }
    /**
     * Get tipoUnidade value
     * @return \StructType\TipoUnidadeType|null
     */
    public function getTipoUnidade()
    {
        return $this->tipoUnidade;
    }
    /**
     * Set tipoUnidade value
     * @param \StructType\TipoUnidadeType $tipoUnidade
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setTipoUnidade(\StructType\TipoUnidadeType $tipoUnidade = null)
    {
        $this->tipoUnidade = $tipoUnidade;
        return $this;
    }
    /**
     * Get esferaAdministrativa value
     * @return \StructType\EsferaAdministrativaType|null
     */
    public function getEsferaAdministrativa()
    {
        return $this->esferaAdministrativa;
    }
    /**
     * Set esferaAdministrativa value
     * @param \StructType\EsferaAdministrativaType $esferaAdministrativa
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setEsferaAdministrativa(\StructType\EsferaAdministrativaType $esferaAdministrativa = null)
    {
        $this->esferaAdministrativa = $esferaAdministrativa;
        return $this;
    }
    /**
     * Get MunicipioGestor value
     * @return \StructType\MunicipioType|null
     */
    public function getMunicipioGestor()
    {
        return $this->MunicipioGestor;
    }
    /**
     * Set MunicipioGestor value
     * @param \StructType\MunicipioType $municipioGestor
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setMunicipioGestor(\StructType\MunicipioType $municipioGestor = null)
    {
        $this->MunicipioGestor = $municipioGestor;
        return $this;
    }
    /**
     * Get Telefone value
     * @return \StructType\TelefoneType[]|null
     */
    public function getTelefone()
    {
        return $this->Telefone;
    }
    /**
     * Set Telefone value
     * @throws \InvalidArgumentException
     * @param \StructType\TelefoneType[] $telefone
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setTelefone(array $telefone = array())
    {
        foreach ($telefone as $dadosGeraisEstabelecimentoSaudeTypeTelefoneItem) {
            // validation for constraint: itemType
            if (!$dadosGeraisEstabelecimentoSaudeTypeTelefoneItem instanceof \StructType\TelefoneType) {
                throw new \InvalidArgumentException(sprintf('The Telefone property can only contain items of \StructType\TelefoneType, "%s" given', is_object($dadosGeraisEstabelecimentoSaudeTypeTelefoneItem) ? get_class($dadosGeraisEstabelecimentoSaudeTypeTelefoneItem) : gettype($dadosGeraisEstabelecimentoSaudeTypeTelefoneItem)), __LINE__);
            }
        }
        $this->Telefone = $telefone;
        return $this;
    }
    /**
     * Add item to Telefone value
     * @throws \InvalidArgumentException
     * @param \StructType\TelefoneType $item
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function addToTelefone(\StructType\TelefoneType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TelefoneType) {
            throw new \InvalidArgumentException(sprintf('The Telefone property can only contain items of \StructType\TelefoneType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Telefone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\EmailType|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \StructType\EmailType $email
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setEmail(\StructType\EmailType $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Localizacao value
     * @return \StructType\LocalizacaoType|null
     */
    public function getLocalizacao()
    {
        return $this->Localizacao;
    }
    /**
     * Set Localizacao value
     * @param \StructType\LocalizacaoType $localizacao
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setLocalizacao(\StructType\LocalizacaoType $localizacao = null)
    {
        $this->Localizacao = $localizacao;
        return $this;
    }
    /**
     * Get perteceSistemaSUS value
     * @return bool|null
     */
    public function getPerteceSistemaSUS()
    {
        return $this->perteceSistemaSUS;
    }
    /**
     * Set perteceSistemaSUS value
     * @param bool $perteceSistemaSUS
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public function setPerteceSistemaSUS($perteceSistemaSUS = null)
    {
        $this->perteceSistemaSUS = $perteceSistemaSUS;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DadosGeraisEstabelecimentoSaudeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
