<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipoUnidadeType StructType
 * @subpackage Structs
 */
class TipoUnidadeType extends AbstractStructBase
{
    /**
     * The codigo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $codigo;
    /**
     * The descricao
     * Meta informations extracted from the WSDL
     * - documentation: Descrição do Tipo de Unidade do Estabelecimento de Saúde..
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $descricao;
    /**
     * Constructor method for TipoUnidadeType
     * @uses TipoUnidadeType::setCodigo()
     * @uses TipoUnidadeType::setDescricao()
     * @param string $codigo
     * @param string $descricao
     */
    public function __construct($codigo = null, $descricao = null)
    {
        $this
            ->setCodigo($codigo)
            ->setDescricao($descricao);
    }
    /**
     * Get codigo value
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @uses \EnumType\Codigo::valueIsValid()
     * @uses \EnumType\Codigo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codigo
     * @return \StructType\TipoUnidadeType
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Codigo::valueIsValid($codigo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $codigo, implode(', ', \EnumType\Codigo::getValidValues())), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get descricao value
     * @return string
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    /**
     * Set descricao value
     * @param string $descricao
     * @return \StructType\TipoUnidadeType
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        $this->descricao = $descricao;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TipoUnidadeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
