<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipoTelefoneType StructType
 * @subpackage Structs
 */
class TipoTelefoneType extends AbstractStructBase
{
    /**
     * The codigoTipoTelefone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Código do tipo de telefone.
     * - maxLength: 2
     * - pattern: [0-9]*
     * @var string
     */
    public $codigoTipoTelefone;
    /**
     * The descricaoTipoTelefone
     * Meta informations extracted from the WSDL
     * - documentation: Descrição do tipo de telefone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $descricaoTipoTelefone;
    /**
     * Constructor method for TipoTelefoneType
     * @uses TipoTelefoneType::setCodigoTipoTelefone()
     * @uses TipoTelefoneType::setDescricaoTipoTelefone()
     * @param string $codigoTipoTelefone
     * @param string $descricaoTipoTelefone
     */
    public function __construct($codigoTipoTelefone = null, $descricaoTipoTelefone = null)
    {
        $this
            ->setCodigoTipoTelefone($codigoTipoTelefone)
            ->setDescricaoTipoTelefone($descricaoTipoTelefone);
    }
    /**
     * Get codigoTipoTelefone value
     * @return string
     */
    public function getCodigoTipoTelefone()
    {
        return $this->codigoTipoTelefone;
    }
    /**
     * Set codigoTipoTelefone value
     * @param string $codigoTipoTelefone
     * @return \StructType\TipoTelefoneType
     */
    public function setCodigoTipoTelefone($codigoTipoTelefone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codigoTipoTelefone) && strlen($codigoTipoTelefone) > 2) || (is_array($codigoTipoTelefone) && count($codigoTipoTelefone) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($codigoTipoTelefone) ? strlen($codigoTipoTelefone) : count($codigoTipoTelefone)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($codigoTipoTelefone) && !preg_match('/[0-9]*/', $codigoTipoTelefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($codigoTipoTelefone, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codigoTipoTelefone) && !is_string($codigoTipoTelefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoTipoTelefone)), __LINE__);
        }
        $this->codigoTipoTelefone = $codigoTipoTelefone;
        return $this;
    }
    /**
     * Get descricaoTipoTelefone value
     * @return string|null
     */
    public function getDescricaoTipoTelefone()
    {
        return $this->descricaoTipoTelefone;
    }
    /**
     * Set descricaoTipoTelefone value
     * @param string $descricaoTipoTelefone
     * @return \StructType\TipoTelefoneType
     */
    public function setDescricaoTipoTelefone($descricaoTipoTelefone = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoTipoTelefone) && !is_string($descricaoTipoTelefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricaoTipoTelefone)), __LINE__);
        }
        $this->descricaoTipoTelefone = $descricaoTipoTelefone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TipoTelefoneType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
