<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MunicipioType StructType
 * @subpackage Structs
 */
class MunicipioType extends AbstractStructBase
{
    /**
     * The codigoMunicipio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Codigo IBGE do Municipio.
     * - maxLength: 6
     * - minLength: 1
     * - pattern: [0-9]*
     * @var string
     */
    public $codigoMunicipio;
    /**
     * The nomeMunicipio
     * Meta informations extracted from the WSDL
     * - documentation: Nome do Municipio.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nomeMunicipio;
    /**
     * The UF
     * Meta informations extracted from the WSDL
     * - documentation: Unidade da Federacao.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UFType
     */
    public $UF;
    /**
     * Constructor method for MunicipioType
     * @uses MunicipioType::setCodigoMunicipio()
     * @uses MunicipioType::setNomeMunicipio()
     * @uses MunicipioType::setUF()
     * @param string $codigoMunicipio
     * @param string $nomeMunicipio
     * @param \StructType\UFType $uF
     */
    public function __construct($codigoMunicipio = null, $nomeMunicipio = null, \StructType\UFType $uF = null)
    {
        $this
            ->setCodigoMunicipio($codigoMunicipio)
            ->setNomeMunicipio($nomeMunicipio)
            ->setUF($uF);
    }
    /**
     * Get codigoMunicipio value
     * @return string|null
     */
    public function getCodigoMunicipio()
    {
        return $this->codigoMunicipio;
    }
    /**
     * Set codigoMunicipio value
     * @param string $codigoMunicipio
     * @return \StructType\MunicipioType
     */
    public function setCodigoMunicipio($codigoMunicipio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codigoMunicipio) && strlen($codigoMunicipio) > 6) || (is_array($codigoMunicipio) && count($codigoMunicipio) > 6)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s) at most, "%d" length given', is_scalar($codigoMunicipio) ? strlen($codigoMunicipio) : count($codigoMunicipio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($codigoMunicipio) && strlen($codigoMunicipio) < 1) || (is_array($codigoMunicipio) && count($codigoMunicipio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($codigoMunicipio) && !preg_match('/[0-9]*/', $codigoMunicipio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($codigoMunicipio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codigoMunicipio) && !is_string($codigoMunicipio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoMunicipio)), __LINE__);
        }
        $this->codigoMunicipio = $codigoMunicipio;
        return $this;
    }
    /**
     * Get nomeMunicipio value
     * @return string|null
     */
    public function getNomeMunicipio()
    {
        return $this->nomeMunicipio;
    }
    /**
     * Set nomeMunicipio value
     * @param string $nomeMunicipio
     * @return \StructType\MunicipioType
     */
    public function setNomeMunicipio($nomeMunicipio = null)
    {
        // validation for constraint: string
        if (!is_null($nomeMunicipio) && !is_string($nomeMunicipio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeMunicipio)), __LINE__);
        }
        $this->nomeMunicipio = $nomeMunicipio;
        return $this;
    }
    /**
     * Get UF value
     * @return \StructType\UFType|null
     */
    public function getUF()
    {
        return $this->UF;
    }
    /**
     * Set UF value
     * @param \StructType\UFType $uF
     * @return \StructType\MunicipioType
     */
    public function setUF(\StructType\UFType $uF = null)
    {
        $this->UF = $uF;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MunicipioType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
