<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FiltroPesquisaEstabelecimentoSaudeType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Código do CNES. | CNPJ do Estabelecimento de Saúde
 * @subpackage Structs
 */
class FiltroPesquisaEstabelecimentoSaudeType extends AbstractStructBase
{
    /**
     * The CodigoCNES
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: cnes:CodigoCNES
     * @var \StructType\CodigoCNESType
     */
    public $CodigoCNES;
    /**
     * The CNPJ
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: cnpj:CNPJ
     * @var \StructType\CNPJType
     */
    public $CNPJ;
    /**
     * Constructor method for FiltroPesquisaEstabelecimentoSaudeType
     * @uses FiltroPesquisaEstabelecimentoSaudeType::setCodigoCNES()
     * @uses FiltroPesquisaEstabelecimentoSaudeType::setCNPJ()
     * @param \StructType\CodigoCNESType $codigoCNES
     * @param \StructType\CNPJType $cNPJ
     */
    public function __construct(\StructType\CodigoCNESType $codigoCNES = null, \StructType\CNPJType $cNPJ = null)
    {
        $this
            ->setCodigoCNES($codigoCNES)
            ->setCNPJ($cNPJ);
    }
    /**
     * Get CodigoCNES value
     * @return \StructType\CodigoCNESType|null
     */
    public function getCodigoCNES()
    {
        return $this->CodigoCNES;
    }
    /**
     * Set CodigoCNES value
     * @param \StructType\CodigoCNESType $codigoCNES
     * @return \StructType\FiltroPesquisaEstabelecimentoSaudeType
     */
    public function setCodigoCNES(\StructType\CodigoCNESType $codigoCNES = null)
    {
        $this->CodigoCNES = $codigoCNES;
        return $this;
    }
    /**
     * Get CNPJ value
     * @return \StructType\CNPJType|null
     */
    public function getCNPJ()
    {
        return $this->CNPJ;
    }
    /**
     * Set CNPJ value
     * @param \StructType\CNPJType $cNPJ
     * @return \StructType\FiltroPesquisaEstabelecimentoSaudeType
     */
    public function setCNPJ(\StructType\CNPJType $cNPJ = null)
    {
        $this->CNPJ = $cNPJ;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FiltroPesquisaEstabelecimentoSaudeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
