<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FiltroLocalizacaoEstabelecimentoSaudeType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Localização do estabelecimento. | Tipo de Unidade do Estabelecimento de Saúde. | Paginação enviada para uma consulta.
 * @subpackage Structs
 */
class FiltroLocalizacaoEstabelecimentoSaudeType extends AbstractStructBase
{
    /**
     * The Localizacao
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: localizacao:Localizacao
     * @var \StructType\LocalizacaoType
     */
    public $Localizacao;
    /**
     * The tipoUnidade
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: tipounidade:tipoUnidade
     * @var \StructType\TipoUnidadeType
     */
    public $tipoUnidade;
    /**
     * The Paginacao
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: paginacao:Paginacao
     * @var \StructType\PaginacaoType
     */
    public $Paginacao;
    /**
     * Constructor method for FiltroLocalizacaoEstabelecimentoSaudeType
     * @uses FiltroLocalizacaoEstabelecimentoSaudeType::setLocalizacao()
     * @uses FiltroLocalizacaoEstabelecimentoSaudeType::setTipoUnidade()
     * @uses FiltroLocalizacaoEstabelecimentoSaudeType::setPaginacao()
     * @param \StructType\LocalizacaoType $localizacao
     * @param \StructType\TipoUnidadeType $tipoUnidade
     * @param \StructType\PaginacaoType $paginacao
     */
    public function __construct(\StructType\LocalizacaoType $localizacao = null, \StructType\TipoUnidadeType $tipoUnidade = null, \StructType\PaginacaoType $paginacao = null)
    {
        $this
            ->setLocalizacao($localizacao)
            ->setTipoUnidade($tipoUnidade)
            ->setPaginacao($paginacao);
    }
    /**
     * Get Localizacao value
     * @return \StructType\LocalizacaoType
     */
    public function getLocalizacao()
    {
        return $this->Localizacao;
    }
    /**
     * Set Localizacao value
     * @param \StructType\LocalizacaoType $localizacao
     * @return \StructType\FiltroLocalizacaoEstabelecimentoSaudeType
     */
    public function setLocalizacao(\StructType\LocalizacaoType $localizacao = null)
    {
        $this->Localizacao = $localizacao;
        return $this;
    }
    /**
     * Get tipoUnidade value
     * @return \StructType\TipoUnidadeType
     */
    public function getTipoUnidade()
    {
        return $this->tipoUnidade;
    }
    /**
     * Set tipoUnidade value
     * @param \StructType\TipoUnidadeType $tipoUnidade
     * @return \StructType\FiltroLocalizacaoEstabelecimentoSaudeType
     */
    public function setTipoUnidade(\StructType\TipoUnidadeType $tipoUnidade = null)
    {
        $this->tipoUnidade = $tipoUnidade;
        return $this;
    }
    /**
     * Get Paginacao value
     * @return \StructType\PaginacaoType|null
     */
    public function getPaginacao()
    {
        return $this->Paginacao;
    }
    /**
     * Set Paginacao value
     * @param \StructType\PaginacaoType $paginacao
     * @return \StructType\FiltroLocalizacaoEstabelecimentoSaudeType
     */
    public function setPaginacao(\StructType\PaginacaoType $paginacao = null)
    {
        $this->Paginacao = $paginacao;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FiltroLocalizacaoEstabelecimentoSaudeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
