<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnderecoType StructType
 * @subpackage Structs
 */
class EnderecoType extends AbstractStructBase
{
    /**
     * The identificador
     * Meta informations extracted from the WSDL
     * - documentation: Código de identificação.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $identificador;
    /**
     * The TipoEndereco
     * Meta informations extracted from the WSDL
     * - documentation: Tipo de Endereco (1 = comercial, 2 = residencial).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoEndereco;
    /**
     * The TipoLogradouro
     * Meta informations extracted from the WSDL
     * - documentation: Tipo de Logradouro. Conforme tabela de codigo de Logradouro.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TipoLogradouroType
     */
    public $TipoLogradouro;
    /**
     * The nomeLogradouro
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Nome do logradouro. Ex: Dr. Joaquim Lucio
     * - maxLength: 250
     * @var string
     */
    public $nomeLogradouro;
    /**
     * The numero
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Número padrão utilizado pelos campos de paginação. Até 7 casas decimais. | Numero do logradouro. Ex: 10
     * - maxLength: 7
     * - minLength: 1
     * - pattern: [0-9]*
     * @var string
     */
    public $numero;
    /**
     * The complemento
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Complemento do endereco. Ex: Entrada A, AP 1673
     * - maxLength: 50
     * @var string
     */
    public $complemento;
    /**
     * The Bairro
     * Meta informations extracted from the WSDL
     * - documentation: Bairro do endereco. Ex: Setor Jardim Botanico
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BairroType
     */
    public $Bairro;
    /**
     * The CEP
     * Meta informations extracted from the WSDL
     * - documentation: CEP do endereco. Ex: 70000000 (sem formatacao)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CEPType
     */
    public $CEP;
    /**
     * The Municipio
     * Meta informations extracted from the WSDL
     * - documentation: Municipio do endereco.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MunicipioType
     */
    public $Municipio;
    /**
     * The Pais
     * Meta informations extracted from the WSDL
     * - documentation: Pais de endereço.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaisType
     */
    public $Pais;
    /**
     * The municipioInternacional
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Nome do municipio onde reside o usuario, caso o pais nao seja Brasil.
     * - maxLength: 70
     * @var string
     */
    public $municipioInternacional;
    /**
     * Constructor method for EnderecoType
     * @uses EnderecoType::setIdentificador()
     * @uses EnderecoType::setTipoEndereco()
     * @uses EnderecoType::setTipoLogradouro()
     * @uses EnderecoType::setNomeLogradouro()
     * @uses EnderecoType::setNumero()
     * @uses EnderecoType::setComplemento()
     * @uses EnderecoType::setBairro()
     * @uses EnderecoType::setCEP()
     * @uses EnderecoType::setMunicipio()
     * @uses EnderecoType::setPais()
     * @uses EnderecoType::setMunicipioInternacional()
     * @param int $identificador
     * @param string $tipoEndereco
     * @param \StructType\TipoLogradouroType $tipoLogradouro
     * @param string $nomeLogradouro
     * @param string $numero
     * @param string $complemento
     * @param \StructType\BairroType $bairro
     * @param \StructType\CEPType $cEP
     * @param \StructType\MunicipioType $municipio
     * @param \StructType\PaisType $pais
     * @param string $municipioInternacional
     */
    public function __construct($identificador = null, $tipoEndereco = null, \StructType\TipoLogradouroType $tipoLogradouro = null, $nomeLogradouro = null, $numero = null, $complemento = null, \StructType\BairroType $bairro = null, \StructType\CEPType $cEP = null, \StructType\MunicipioType $municipio = null, \StructType\PaisType $pais = null, $municipioInternacional = null)
    {
        $this
            ->setIdentificador($identificador)
            ->setTipoEndereco($tipoEndereco)
            ->setTipoLogradouro($tipoLogradouro)
            ->setNomeLogradouro($nomeLogradouro)
            ->setNumero($numero)
            ->setComplemento($complemento)
            ->setBairro($bairro)
            ->setCEP($cEP)
            ->setMunicipio($municipio)
            ->setPais($pais)
            ->setMunicipioInternacional($municipioInternacional);
    }
    /**
     * Get identificador value
     * @return int|null
     */
    public function getIdentificador()
    {
        return $this->identificador;
    }
    /**
     * Set identificador value
     * @param int $identificador
     * @return \StructType\EnderecoType
     */
    public function setIdentificador($identificador = null)
    {
        // validation for constraint: int
        if (!is_null($identificador) && !is_numeric($identificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($identificador)), __LINE__);
        }
        $this->identificador = $identificador;
        return $this;
    }
    /**
     * Get TipoEndereco value
     * @return string|null
     */
    public function getTipoEndereco()
    {
        return $this->TipoEndereco;
    }
    /**
     * Set TipoEndereco value
     * @uses \EnumType\TipoEnderecoType::valueIsValid()
     * @uses \EnumType\TipoEnderecoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoEndereco
     * @return \StructType\EnderecoType
     */
    public function setTipoEndereco($tipoEndereco = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoEnderecoType::valueIsValid($tipoEndereco)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tipoEndereco, implode(', ', \EnumType\TipoEnderecoType::getValidValues())), __LINE__);
        }
        $this->TipoEndereco = $tipoEndereco;
        return $this;
    }
    /**
     * Get TipoLogradouro value
     * @return \StructType\TipoLogradouroType|null
     */
    public function getTipoLogradouro()
    {
        return $this->TipoLogradouro;
    }
    /**
     * Set TipoLogradouro value
     * @param \StructType\TipoLogradouroType $tipoLogradouro
     * @return \StructType\EnderecoType
     */
    public function setTipoLogradouro(\StructType\TipoLogradouroType $tipoLogradouro = null)
    {
        $this->TipoLogradouro = $tipoLogradouro;
        return $this;
    }
    /**
     * Get nomeLogradouro value
     * @return string|null
     */
    public function getNomeLogradouro()
    {
        return $this->nomeLogradouro;
    }
    /**
     * Set nomeLogradouro value
     * @param string $nomeLogradouro
     * @return \StructType\EnderecoType
     */
    public function setNomeLogradouro($nomeLogradouro = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nomeLogradouro) && strlen($nomeLogradouro) > 250) || (is_array($nomeLogradouro) && count($nomeLogradouro) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($nomeLogradouro) ? strlen($nomeLogradouro) : count($nomeLogradouro)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nomeLogradouro) && !is_string($nomeLogradouro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeLogradouro)), __LINE__);
        }
        $this->nomeLogradouro = $nomeLogradouro;
        return $this;
    }
    /**
     * Get numero value
     * @return string|null
     */
    public function getNumero()
    {
        return $this->numero;
    }
    /**
     * Set numero value
     * @param string $numero
     * @return \StructType\EnderecoType
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numero) && strlen($numero) > 7) || (is_array($numero) && count($numero) > 7)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 7 element(s) or a scalar of 7 character(s) at most, "%d" length given', is_scalar($numero) ? strlen($numero) : count($numero)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($numero) && strlen($numero) < 1) || (is_array($numero) && count($numero) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($numero) && !preg_match('/[0-9]*/', $numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($numero, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numero)), __LINE__);
        }
        $this->numero = $numero;
        return $this;
    }
    /**
     * Get complemento value
     * @return string|null
     */
    public function getComplemento()
    {
        return $this->complemento;
    }
    /**
     * Set complemento value
     * @param string $complemento
     * @return \StructType\EnderecoType
     */
    public function setComplemento($complemento = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($complemento) && strlen($complemento) > 50) || (is_array($complemento) && count($complemento) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($complemento) ? strlen($complemento) : count($complemento)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($complemento) && !is_string($complemento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($complemento)), __LINE__);
        }
        $this->complemento = $complemento;
        return $this;
    }
    /**
     * Get Bairro value
     * @return \StructType\BairroType|null
     */
    public function getBairro()
    {
        return $this->Bairro;
    }
    /**
     * Set Bairro value
     * @param \StructType\BairroType $bairro
     * @return \StructType\EnderecoType
     */
    public function setBairro(\StructType\BairroType $bairro = null)
    {
        $this->Bairro = $bairro;
        return $this;
    }
    /**
     * Get CEP value
     * @return \StructType\CEPType|null
     */
    public function getCEP()
    {
        return $this->CEP;
    }
    /**
     * Set CEP value
     * @param \StructType\CEPType $cEP
     * @return \StructType\EnderecoType
     */
    public function setCEP(\StructType\CEPType $cEP = null)
    {
        $this->CEP = $cEP;
        return $this;
    }
    /**
     * Get Municipio value
     * @return \StructType\MunicipioType|null
     */
    public function getMunicipio()
    {
        return $this->Municipio;
    }
    /**
     * Set Municipio value
     * @param \StructType\MunicipioType $municipio
     * @return \StructType\EnderecoType
     */
    public function setMunicipio(\StructType\MunicipioType $municipio = null)
    {
        $this->Municipio = $municipio;
        return $this;
    }
    /**
     * Get Pais value
     * @return \StructType\PaisType|null
     */
    public function getPais()
    {
        return $this->Pais;
    }
    /**
     * Set Pais value
     * @param \StructType\PaisType $pais
     * @return \StructType\EnderecoType
     */
    public function setPais(\StructType\PaisType $pais = null)
    {
        $this->Pais = $pais;
        return $this;
    }
    /**
     * Get municipioInternacional value
     * @return string|null
     */
    public function getMunicipioInternacional()
    {
        return $this->municipioInternacional;
    }
    /**
     * Set municipioInternacional value
     * @param string $municipioInternacional
     * @return \StructType\EnderecoType
     */
    public function setMunicipioInternacional($municipioInternacional = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($municipioInternacional) && strlen($municipioInternacional) > 70) || (is_array($municipioInternacional) && count($municipioInternacional) > 70)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 70 element(s) or a scalar of 70 character(s) at most, "%d" length given', is_scalar($municipioInternacional) ? strlen($municipioInternacional) : count($municipioInternacional)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($municipioInternacional) && !is_string($municipioInternacional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($municipioInternacional)), __LINE__);
        }
        $this->municipioInternacional = $municipioInternacional;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EnderecoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
