<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CPFType StructType
 * @subpackage Structs
 */
class CPFType extends AbstractStructBase
{
    /**
     * The numeroCPF
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Numero do CPF sem formatacao. Ex: 09999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: [0-9]*
     * @var string
     */
    public $numeroCPF;
    /**
     * Constructor method for CPFType
     * @uses CPFType::setNumeroCPF()
     * @param string $numeroCPF
     */
    public function __construct($numeroCPF = null)
    {
        $this
            ->setNumeroCPF($numeroCPF);
    }
    /**
     * Get numeroCPF value
     * @return string
     */
    public function getNumeroCPF()
    {
        return $this->numeroCPF;
    }
    /**
     * Set numeroCPF value
     * @param string $numeroCPF
     * @return \StructType\CPFType
     */
    public function setNumeroCPF($numeroCPF = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numeroCPF) && strlen($numeroCPF) > 11) || (is_array($numeroCPF) && count($numeroCPF) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($numeroCPF) ? strlen($numeroCPF) : count($numeroCPF)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($numeroCPF) && strlen($numeroCPF) < 11) || (is_array($numeroCPF) && count($numeroCPF) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($numeroCPF) && !preg_match('/[0-9]*/', $numeroCPF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($numeroCPF, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numeroCPF) && !is_string($numeroCPF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroCPF)), __LINE__);
        }
        $this->numeroCPF = $numeroCPF;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CPFType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
