<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BairroType StructType
 * @subpackage Structs
 */
class BairroType extends AbstractStructBase
{
    /**
     * The codigoBairro
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Código do bairro.
     * - maxLength: 8
     * - pattern: [0-9]*
     * @var string
     */
    public $codigoBairro;
    /**
     * The descricaoBairro
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Descrição do bairro.
     * - maxLength: 72
     * @var string
     */
    public $descricaoBairro;
    /**
     * Constructor method for BairroType
     * @uses BairroType::setCodigoBairro()
     * @uses BairroType::setDescricaoBairro()
     * @param string $codigoBairro
     * @param string $descricaoBairro
     */
    public function __construct($codigoBairro = null, $descricaoBairro = null)
    {
        $this
            ->setCodigoBairro($codigoBairro)
            ->setDescricaoBairro($descricaoBairro);
    }
    /**
     * Get codigoBairro value
     * @return string|null
     */
    public function getCodigoBairro()
    {
        return $this->codigoBairro;
    }
    /**
     * Set codigoBairro value
     * @param string $codigoBairro
     * @return \StructType\BairroType
     */
    public function setCodigoBairro($codigoBairro = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codigoBairro) && strlen($codigoBairro) > 8) || (is_array($codigoBairro) && count($codigoBairro) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($codigoBairro) ? strlen($codigoBairro) : count($codigoBairro)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($codigoBairro) && !preg_match('/[0-9]*/', $codigoBairro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($codigoBairro, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codigoBairro) && !is_string($codigoBairro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoBairro)), __LINE__);
        }
        $this->codigoBairro = $codigoBairro;
        return $this;
    }
    /**
     * Get descricaoBairro value
     * @return string|null
     */
    public function getDescricaoBairro()
    {
        return $this->descricaoBairro;
    }
    /**
     * Set descricaoBairro value
     * @param string $descricaoBairro
     * @return \StructType\BairroType
     */
    public function setDescricaoBairro($descricaoBairro = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($descricaoBairro) && strlen($descricaoBairro) > 72) || (is_array($descricaoBairro) && count($descricaoBairro) > 72)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 72 element(s) or a scalar of 72 character(s) at most, "%d" length given', is_scalar($descricaoBairro) ? strlen($descricaoBairro) : count($descricaoBairro)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($descricaoBairro) && !is_string($descricaoBairro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricaoBairro)), __LINE__);
        }
        $this->descricaoBairro = $descricaoBairro;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BairroType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
