<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Localizar ServiceType
 * @subpackage Services
 */
class Localizar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named localizarEstabelecimentoSaude
     * Meta informations extracted from the WSDL
     * - documentation: Localiza os Estabelecimentos de Saude pelas coordenadas. | Consultar os estabelecimentos de saúde proximo a localização informada | Consultar os estabelecimentos de saúde proximo a localização informada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RequestLocalizarEstabelecimentoSaude $requestLocalizarEstabelecimentoSaude
     * @return \StructType\ResponseLocalizarEstabelecimentoSaude|bool
     */
    public function localizarEstabelecimentoSaude(\StructType\RequestLocalizarEstabelecimentoSaude $requestLocalizarEstabelecimentoSaude)
    {
        try {
            $this->setResult(self::getSoapClient()->localizarEstabelecimentoSaude($requestLocalizarEstabelecimentoSaude));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseLocalizarEstabelecimentoSaude
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
