<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UFType StructType
 * @subpackage Structs
 */
class UFType extends AbstractStructBase
{
    /**
     * The codigoUF
     * Meta informations extracted from the WSDL
     * - documentation: Codigo IBGE da Unidade da Federacao.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $codigoUF;
    /**
     * The siglaUF
     * Meta informations extracted from the WSDL
     * - documentation: Sigla da Unidade da Federacao.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $siglaUF;
    /**
     * The codigoRegiao
     * Meta informations extracted from the WSDL
     * - documentation: Contem informacoes referentes as 5 regioes do Brasil (tambem denominadas macrorregioes).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $codigoRegiao;
    /**
     * The nomeUF
     * Meta informations extracted from the WSDL
     * - documentation: Nome da Unidade da Federacao.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nomeUF;
    /**
     * Constructor method for UFType
     * @uses UFType::setCodigoUF()
     * @uses UFType::setSiglaUF()
     * @uses UFType::setCodigoRegiao()
     * @uses UFType::setNomeUF()
     * @param string $codigoUF
     * @param string $siglaUF
     * @param string $codigoRegiao
     * @param string $nomeUF
     */
    public function __construct($codigoUF = null, $siglaUF = null, $codigoRegiao = null, $nomeUF = null)
    {
        $this
            ->setCodigoUF($codigoUF)
            ->setSiglaUF($siglaUF)
            ->setCodigoRegiao($codigoRegiao)
            ->setNomeUF($nomeUF);
    }
    /**
     * Get codigoUF value
     * @return string
     */
    public function getCodigoUF()
    {
        return $this->codigoUF;
    }
    /**
     * Set codigoUF value
     * @param string $codigoUF
     * @return \StructType\UFType
     */
    public function setCodigoUF($codigoUF = null)
    {
        // validation for constraint: string
        if (!is_null($codigoUF) && !is_string($codigoUF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoUF)), __LINE__);
        }
        $this->codigoUF = $codigoUF;
        return $this;
    }
    /**
     * Get siglaUF value
     * @return string|null
     */
    public function getSiglaUF()
    {
        return $this->siglaUF;
    }
    /**
     * Set siglaUF value
     * @param string $siglaUF
     * @return \StructType\UFType
     */
    public function setSiglaUF($siglaUF = null)
    {
        // validation for constraint: string
        if (!is_null($siglaUF) && !is_string($siglaUF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siglaUF)), __LINE__);
        }
        $this->siglaUF = $siglaUF;
        return $this;
    }
    /**
     * Get codigoRegiao value
     * @return string|null
     */
    public function getCodigoRegiao()
    {
        return $this->codigoRegiao;
    }
    /**
     * Set codigoRegiao value
     * @param string $codigoRegiao
     * @return \StructType\UFType
     */
    public function setCodigoRegiao($codigoRegiao = null)
    {
        // validation for constraint: string
        if (!is_null($codigoRegiao) && !is_string($codigoRegiao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoRegiao)), __LINE__);
        }
        $this->codigoRegiao = $codigoRegiao;
        return $this;
    }
    /**
     * Get nomeUF value
     * @return string|null
     */
    public function getNomeUF()
    {
        return $this->nomeUF;
    }
    /**
     * Set nomeUF value
     * @param string $nomeUF
     * @return \StructType\UFType
     */
    public function setNomeUF($nomeUF = null)
    {
        // validation for constraint: string
        if (!is_null($nomeUF) && !is_string($nomeUF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeUF)), __LINE__);
        }
        $this->nomeUF = $nomeUF;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UFType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
