<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipoLogradouroType StructType
 * @subpackage Structs
 */
class TipoLogradouroType extends AbstractStructBase
{
    /**
     * The codigoTipoLogradouro
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Código do tipo de logradouro.
     * - maxLength: 3
     * - pattern: [0-9]*
     * @var string
     */
    public $codigoTipoLogradouro;
    /**
     * The descricaoTipoLogradouro
     * Meta informations extracted from the WSDL
     * - documentation: Descrição do tipo de logradouro.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $descricaoTipoLogradouro;
    /**
     * Constructor method for TipoLogradouroType
     * @uses TipoLogradouroType::setCodigoTipoLogradouro()
     * @uses TipoLogradouroType::setDescricaoTipoLogradouro()
     * @param string $codigoTipoLogradouro
     * @param string $descricaoTipoLogradouro
     */
    public function __construct($codigoTipoLogradouro = null, $descricaoTipoLogradouro = null)
    {
        $this
            ->setCodigoTipoLogradouro($codigoTipoLogradouro)
            ->setDescricaoTipoLogradouro($descricaoTipoLogradouro);
    }
    /**
     * Get codigoTipoLogradouro value
     * @return string
     */
    public function getCodigoTipoLogradouro()
    {
        return $this->codigoTipoLogradouro;
    }
    /**
     * Set codigoTipoLogradouro value
     * @param string $codigoTipoLogradouro
     * @return \StructType\TipoLogradouroType
     */
    public function setCodigoTipoLogradouro($codigoTipoLogradouro = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codigoTipoLogradouro) && strlen($codigoTipoLogradouro) > 3) || (is_array($codigoTipoLogradouro) && count($codigoTipoLogradouro) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($codigoTipoLogradouro) ? strlen($codigoTipoLogradouro) : count($codigoTipoLogradouro)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($codigoTipoLogradouro) && !preg_match('/[0-9]*/', $codigoTipoLogradouro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($codigoTipoLogradouro, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codigoTipoLogradouro) && !is_string($codigoTipoLogradouro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoTipoLogradouro)), __LINE__);
        }
        $this->codigoTipoLogradouro = $codigoTipoLogradouro;
        return $this;
    }
    /**
     * Get descricaoTipoLogradouro value
     * @return string|null
     */
    public function getDescricaoTipoLogradouro()
    {
        return $this->descricaoTipoLogradouro;
    }
    /**
     * Set descricaoTipoLogradouro value
     * @param string $descricaoTipoLogradouro
     * @return \StructType\TipoLogradouroType
     */
    public function setDescricaoTipoLogradouro($descricaoTipoLogradouro = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoTipoLogradouro) && !is_string($descricaoTipoLogradouro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricaoTipoLogradouro)), __LINE__);
        }
        $this->descricaoTipoLogradouro = $descricaoTipoLogradouro;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TipoLogradouroType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
