<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaisType StructType
 * @subpackage Structs
 */
class PaisType extends AbstractStructBase
{
    /**
     * The codigoPais
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Codigo de identificacao do Pais (SIA e SIH).
     * - pattern: [0-9]*
     * @var string
     */
    public $codigoPais;
    /**
     * The codigoPaisAntigo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Codigo antigo de identificacao do Pais.
     * - pattern: [0-9]*
     * @var string
     */
    public $codigoPaisAntigo;
    /**
     * The nomePais
     * Meta informations extracted from the WSDL
     * - documentation: Nome do Pais.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nomePais;
    /**
     * Constructor method for PaisType
     * @uses PaisType::setCodigoPais()
     * @uses PaisType::setCodigoPaisAntigo()
     * @uses PaisType::setNomePais()
     * @param string $codigoPais
     * @param string $codigoPaisAntigo
     * @param string $nomePais
     */
    public function __construct($codigoPais = null, $codigoPaisAntigo = null, $nomePais = null)
    {
        $this
            ->setCodigoPais($codigoPais)
            ->setCodigoPaisAntigo($codigoPaisAntigo)
            ->setNomePais($nomePais);
    }
    /**
     * Get codigoPais value
     * @return string|null
     */
    public function getCodigoPais()
    {
        return $this->codigoPais;
    }
    /**
     * Set codigoPais value
     * @param string $codigoPais
     * @return \StructType\PaisType
     */
    public function setCodigoPais($codigoPais = null)
    {
        // validation for constraint: pattern
        if (is_scalar($codigoPais) && !preg_match('/[0-9]*/', $codigoPais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($codigoPais, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codigoPais) && !is_string($codigoPais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoPais)), __LINE__);
        }
        $this->codigoPais = $codigoPais;
        return $this;
    }
    /**
     * Get codigoPaisAntigo value
     * @return string|null
     */
    public function getCodigoPaisAntigo()
    {
        return $this->codigoPaisAntigo;
    }
    /**
     * Set codigoPaisAntigo value
     * @param string $codigoPaisAntigo
     * @return \StructType\PaisType
     */
    public function setCodigoPaisAntigo($codigoPaisAntigo = null)
    {
        // validation for constraint: pattern
        if (is_scalar($codigoPaisAntigo) && !preg_match('/[0-9]*/', $codigoPaisAntigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($codigoPaisAntigo, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codigoPaisAntigo) && !is_string($codigoPaisAntigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoPaisAntigo)), __LINE__);
        }
        $this->codigoPaisAntigo = $codigoPaisAntigo;
        return $this;
    }
    /**
     * Get nomePais value
     * @return string|null
     */
    public function getNomePais()
    {
        return $this->nomePais;
    }
    /**
     * Set nomePais value
     * @param string $nomePais
     * @return \StructType\PaisType
     */
    public function setNomePais($nomePais = null)
    {
        // validation for constraint: string
        if (!is_null($nomePais) && !is_string($nomePais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomePais)), __LINE__);
        }
        $this->nomePais = $nomePais;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaisType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
