<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaginacaoType StructType
 * @subpackage Structs
 */
class PaginacaoType extends AbstractStructBase
{
    /**
     * The posicaoRegistroInicio
     * Meta informations extracted from the WSDL
     * - documentation: Posição de inicio do registro. | Número padrão utilizado pelos campos de paginação. Até 7 casas decimais. | Numero do logradouro. Ex: 10
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 7
     * - minLength: 1
     * - pattern: [0-9]*
     * @var string
     */
    public $posicaoRegistroInicio;
    /**
     * The quantidadeRegistrosPorPagina
     * Meta informations extracted from the WSDL
     * - documentation: Quantidade de registros por página. | Número padrão utilizado pelos campos de paginação. Até 7 casas decimais. | Numero do logradouro. Ex: 10
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 7
     * - minLength: 1
     * - pattern: [0-9]*
     * @var string
     */
    public $quantidadeRegistrosPorPagina;
    /**
     * The quantidadeRegistros
     * Meta informations extracted from the WSDL
     * - documentation: Quantidade de registros total da consulta. | Número padrão utilizado pelos campos de paginação. Até 7 casas decimais. | Numero do logradouro. Ex: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 7
     * - minLength: 1
     * - pattern: [0-9]*
     * @var string
     */
    public $quantidadeRegistros;
    /**
     * Constructor method for PaginacaoType
     * @uses PaginacaoType::setPosicaoRegistroInicio()
     * @uses PaginacaoType::setQuantidadeRegistrosPorPagina()
     * @uses PaginacaoType::setQuantidadeRegistros()
     * @param string $posicaoRegistroInicio
     * @param string $quantidadeRegistrosPorPagina
     * @param string $quantidadeRegistros
     */
    public function __construct($posicaoRegistroInicio = null, $quantidadeRegistrosPorPagina = null, $quantidadeRegistros = null)
    {
        $this
            ->setPosicaoRegistroInicio($posicaoRegistroInicio)
            ->setQuantidadeRegistrosPorPagina($quantidadeRegistrosPorPagina)
            ->setQuantidadeRegistros($quantidadeRegistros);
    }
    /**
     * Get posicaoRegistroInicio value
     * @return string
     */
    public function getPosicaoRegistroInicio()
    {
        return $this->posicaoRegistroInicio;
    }
    /**
     * Set posicaoRegistroInicio value
     * @param string $posicaoRegistroInicio
     * @return \StructType\PaginacaoType
     */
    public function setPosicaoRegistroInicio($posicaoRegistroInicio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($posicaoRegistroInicio) && strlen($posicaoRegistroInicio) > 7) || (is_array($posicaoRegistroInicio) && count($posicaoRegistroInicio) > 7)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 7 element(s) or a scalar of 7 character(s) at most, "%d" length given', is_scalar($posicaoRegistroInicio) ? strlen($posicaoRegistroInicio) : count($posicaoRegistroInicio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($posicaoRegistroInicio) && strlen($posicaoRegistroInicio) < 1) || (is_array($posicaoRegistroInicio) && count($posicaoRegistroInicio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($posicaoRegistroInicio) && !preg_match('/[0-9]*/', $posicaoRegistroInicio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($posicaoRegistroInicio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($posicaoRegistroInicio) && !is_string($posicaoRegistroInicio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($posicaoRegistroInicio)), __LINE__);
        }
        $this->posicaoRegistroInicio = $posicaoRegistroInicio;
        return $this;
    }
    /**
     * Get quantidadeRegistrosPorPagina value
     * @return string
     */
    public function getQuantidadeRegistrosPorPagina()
    {
        return $this->quantidadeRegistrosPorPagina;
    }
    /**
     * Set quantidadeRegistrosPorPagina value
     * @param string $quantidadeRegistrosPorPagina
     * @return \StructType\PaginacaoType
     */
    public function setQuantidadeRegistrosPorPagina($quantidadeRegistrosPorPagina = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($quantidadeRegistrosPorPagina) && strlen($quantidadeRegistrosPorPagina) > 7) || (is_array($quantidadeRegistrosPorPagina) && count($quantidadeRegistrosPorPagina) > 7)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 7 element(s) or a scalar of 7 character(s) at most, "%d" length given', is_scalar($quantidadeRegistrosPorPagina) ? strlen($quantidadeRegistrosPorPagina) : count($quantidadeRegistrosPorPagina)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($quantidadeRegistrosPorPagina) && strlen($quantidadeRegistrosPorPagina) < 1) || (is_array($quantidadeRegistrosPorPagina) && count($quantidadeRegistrosPorPagina) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($quantidadeRegistrosPorPagina) && !preg_match('/[0-9]*/', $quantidadeRegistrosPorPagina)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($quantidadeRegistrosPorPagina, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($quantidadeRegistrosPorPagina) && !is_string($quantidadeRegistrosPorPagina)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quantidadeRegistrosPorPagina)), __LINE__);
        }
        $this->quantidadeRegistrosPorPagina = $quantidadeRegistrosPorPagina;
        return $this;
    }
    /**
     * Get quantidadeRegistros value
     * @return string|null
     */
    public function getQuantidadeRegistros()
    {
        return $this->quantidadeRegistros;
    }
    /**
     * Set quantidadeRegistros value
     * @param string $quantidadeRegistros
     * @return \StructType\PaginacaoType
     */
    public function setQuantidadeRegistros($quantidadeRegistros = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($quantidadeRegistros) && strlen($quantidadeRegistros) > 7) || (is_array($quantidadeRegistros) && count($quantidadeRegistros) > 7)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 7 element(s) or a scalar of 7 character(s) at most, "%d" length given', is_scalar($quantidadeRegistros) ? strlen($quantidadeRegistros) : count($quantidadeRegistros)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($quantidadeRegistros) && strlen($quantidadeRegistros) < 1) || (is_array($quantidadeRegistros) && count($quantidadeRegistros) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($quantidadeRegistros) && !preg_match('/[0-9]*/', $quantidadeRegistros)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($quantidadeRegistros, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($quantidadeRegistros) && !is_string($quantidadeRegistros)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quantidadeRegistros)), __LINE__);
        }
        $this->quantidadeRegistros = $quantidadeRegistros;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaginacaoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
