<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NaturezaJuridicaType StructType
 * @subpackage Structs
 */
class NaturezaJuridicaType extends AbstractStructBase
{
    /**
     * The codigoNaturezaJuridica
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Código da Natureza Jurídica da Pessoa.
     * - maxLength: 4
     * @var string
     */
    public $codigoNaturezaJuridica;
    /**
     * The descricaoNaturezaJuridica
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Descrição da Natureza Jurídica da Pessoa.
     * - maxLength: 80
     * @var string
     */
    public $descricaoNaturezaJuridica;
    /**
     * The codigoNaturezaJuridicaConcla
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Código da Natureza Jurídica CONCLA(Comissão Nacional de Classificação).
     * - maxLength: 4
     * @var string
     */
    public $codigoNaturezaJuridicaConcla;
    /**
     * The tipoNaturezaJuridica
     * Meta informations extracted from the WSDL
     * - documentation: Determina o tipo da Natureza Juridica
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TipoNaturezaJuridicaType
     */
    public $tipoNaturezaJuridica;
    /**
     * Constructor method for NaturezaJuridicaType
     * @uses NaturezaJuridicaType::setCodigoNaturezaJuridica()
     * @uses NaturezaJuridicaType::setDescricaoNaturezaJuridica()
     * @uses NaturezaJuridicaType::setCodigoNaturezaJuridicaConcla()
     * @uses NaturezaJuridicaType::setTipoNaturezaJuridica()
     * @param string $codigoNaturezaJuridica
     * @param string $descricaoNaturezaJuridica
     * @param string $codigoNaturezaJuridicaConcla
     * @param \StructType\TipoNaturezaJuridicaType $tipoNaturezaJuridica
     */
    public function __construct($codigoNaturezaJuridica = null, $descricaoNaturezaJuridica = null, $codigoNaturezaJuridicaConcla = null, \StructType\TipoNaturezaJuridicaType $tipoNaturezaJuridica = null)
    {
        $this
            ->setCodigoNaturezaJuridica($codigoNaturezaJuridica)
            ->setDescricaoNaturezaJuridica($descricaoNaturezaJuridica)
            ->setCodigoNaturezaJuridicaConcla($codigoNaturezaJuridicaConcla)
            ->setTipoNaturezaJuridica($tipoNaturezaJuridica);
    }
    /**
     * Get codigoNaturezaJuridica value
     * @return string
     */
    public function getCodigoNaturezaJuridica()
    {
        return $this->codigoNaturezaJuridica;
    }
    /**
     * Set codigoNaturezaJuridica value
     * @param string $codigoNaturezaJuridica
     * @return \StructType\NaturezaJuridicaType
     */
    public function setCodigoNaturezaJuridica($codigoNaturezaJuridica = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codigoNaturezaJuridica) && strlen($codigoNaturezaJuridica) > 4) || (is_array($codigoNaturezaJuridica) && count($codigoNaturezaJuridica) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($codigoNaturezaJuridica) ? strlen($codigoNaturezaJuridica) : count($codigoNaturezaJuridica)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codigoNaturezaJuridica) && !is_string($codigoNaturezaJuridica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoNaturezaJuridica)), __LINE__);
        }
        $this->codigoNaturezaJuridica = $codigoNaturezaJuridica;
        return $this;
    }
    /**
     * Get descricaoNaturezaJuridica value
     * @return string
     */
    public function getDescricaoNaturezaJuridica()
    {
        return $this->descricaoNaturezaJuridica;
    }
    /**
     * Set descricaoNaturezaJuridica value
     * @param string $descricaoNaturezaJuridica
     * @return \StructType\NaturezaJuridicaType
     */
    public function setDescricaoNaturezaJuridica($descricaoNaturezaJuridica = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($descricaoNaturezaJuridica) && strlen($descricaoNaturezaJuridica) > 80) || (is_array($descricaoNaturezaJuridica) && count($descricaoNaturezaJuridica) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($descricaoNaturezaJuridica) ? strlen($descricaoNaturezaJuridica) : count($descricaoNaturezaJuridica)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($descricaoNaturezaJuridica) && !is_string($descricaoNaturezaJuridica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricaoNaturezaJuridica)), __LINE__);
        }
        $this->descricaoNaturezaJuridica = $descricaoNaturezaJuridica;
        return $this;
    }
    /**
     * Get codigoNaturezaJuridicaConcla value
     * @return string
     */
    public function getCodigoNaturezaJuridicaConcla()
    {
        return $this->codigoNaturezaJuridicaConcla;
    }
    /**
     * Set codigoNaturezaJuridicaConcla value
     * @param string $codigoNaturezaJuridicaConcla
     * @return \StructType\NaturezaJuridicaType
     */
    public function setCodigoNaturezaJuridicaConcla($codigoNaturezaJuridicaConcla = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codigoNaturezaJuridicaConcla) && strlen($codigoNaturezaJuridicaConcla) > 4) || (is_array($codigoNaturezaJuridicaConcla) && count($codigoNaturezaJuridicaConcla) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($codigoNaturezaJuridicaConcla) ? strlen($codigoNaturezaJuridicaConcla) : count($codigoNaturezaJuridicaConcla)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codigoNaturezaJuridicaConcla) && !is_string($codigoNaturezaJuridicaConcla)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoNaturezaJuridicaConcla)), __LINE__);
        }
        $this->codigoNaturezaJuridicaConcla = $codigoNaturezaJuridicaConcla;
        return $this;
    }
    /**
     * Get tipoNaturezaJuridica value
     * @return \StructType\TipoNaturezaJuridicaType
     */
    public function getTipoNaturezaJuridica()
    {
        return $this->tipoNaturezaJuridica;
    }
    /**
     * Set tipoNaturezaJuridica value
     * @param \StructType\TipoNaturezaJuridicaType $tipoNaturezaJuridica
     * @return \StructType\NaturezaJuridicaType
     */
    public function setTipoNaturezaJuridica(\StructType\TipoNaturezaJuridicaType $tipoNaturezaJuridica = null)
    {
        $this->tipoNaturezaJuridica = $tipoNaturezaJuridica;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NaturezaJuridicaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
