<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MensagemType StructType
 * @subpackage Structs
 */
class MensagemType extends AbstractStructBase
{
    /**
     * The codigo
     * Meta informations extracted from the WSDL
     * - documentation: Codigo da mensagem padronizada.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $codigo;
    /**
     * The descricao
     * Meta informations extracted from the WSDL
     * - documentation: Descricao da mensagem.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $descricao;
    /**
     * Constructor method for MensagemType
     * @uses MensagemType::setCodigo()
     * @uses MensagemType::setDescricao()
     * @param string $codigo
     * @param string $descricao
     */
    public function __construct($codigo = null, $descricao = null)
    {
        $this
            ->setCodigo($codigo)
            ->setDescricao($descricao);
    }
    /**
     * Get codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param string $codigo
     * @return \StructType\MensagemType
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    /**
     * Set descricao value
     * @param string $descricao
     * @return \StructType\MensagemType
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        $this->descricao = $descricao;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MensagemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
