<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MSFalha StructType
 * @subpackage Structs
 */
class MSFalha extends AbstractStructBase
{
    /**
     * The identificador
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $identificador;
    /**
     * The Mensagem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MensagemType[]
     */
    public $Mensagem;
    /**
     * Constructor method for MSFalha
     * @uses MSFalha::setIdentificador()
     * @uses MSFalha::setMensagem()
     * @param string $identificador
     * @param \StructType\MensagemType[] $mensagem
     */
    public function __construct($identificador = null, array $mensagem = array())
    {
        $this
            ->setIdentificador($identificador)
            ->setMensagem($mensagem);
    }
    /**
     * Get identificador value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentificador()
    {
        return isset($this->identificador) ? $this->identificador : null;
    }
    /**
     * Set identificador value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identificador
     * @return \StructType\MSFalha
     */
    public function setIdentificador($identificador = null)
    {
        // validation for constraint: string
        if (!is_null($identificador) && !is_string($identificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificador)), __LINE__);
        }
        if (is_null($identificador) || (is_array($identificador) && empty($identificador))) {
            unset($this->identificador);
        } else {
            $this->identificador = $identificador;
        }
        return $this;
    }
    /**
     * Get Mensagem value
     * @return \StructType\MensagemType[]|null
     */
    public function getMensagem()
    {
        return $this->Mensagem;
    }
    /**
     * Set Mensagem value
     * @throws \InvalidArgumentException
     * @param \StructType\MensagemType[] $mensagem
     * @return \StructType\MSFalha
     */
    public function setMensagem(array $mensagem = array())
    {
        foreach ($mensagem as $mSFalhaMensagemItem) {
            // validation for constraint: itemType
            if (!$mSFalhaMensagemItem instanceof \StructType\MensagemType) {
                throw new \InvalidArgumentException(sprintf('The Mensagem property can only contain items of \StructType\MensagemType, "%s" given', is_object($mSFalhaMensagemItem) ? get_class($mSFalhaMensagemItem) : gettype($mSFalhaMensagemItem)), __LINE__);
            }
        }
        $this->Mensagem = $mensagem;
        return $this;
    }
    /**
     * Add item to Mensagem value
     * @throws \InvalidArgumentException
     * @param \StructType\MensagemType $item
     * @return \StructType\MSFalha
     */
    public function addToMensagem(\StructType\MensagemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MensagemType) {
            throw new \InvalidArgumentException(sprintf('The Mensagem property can only contain items of \StructType\MensagemType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Mensagem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MSFalha
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
