<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for localizacaoType StructType
 * @subpackage Structs
 */
class LocalizacaoType extends AbstractStructBase
{
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $longitude;
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $latitude;
    /**
     * The geoJson
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $geoJson;
    /**
     * Constructor method for localizacaoType
     * @uses LocalizacaoType::setLongitude()
     * @uses LocalizacaoType::setLatitude()
     * @uses LocalizacaoType::setGeoJson()
     * @param string $longitude
     * @param string $latitude
     * @param string $geoJson
     */
    public function __construct($longitude = null, $latitude = null, $geoJson = null)
    {
        $this
            ->setLongitude($longitude)
            ->setLatitude($latitude)
            ->setGeoJson($geoJson);
    }
    /**
     * Get longitude value
     * @return string
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param string $longitude
     * @return \StructType\LocalizacaoType
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($longitude)), __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get latitude value
     * @return string
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param string $latitude
     * @return \StructType\LocalizacaoType
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get geoJson value
     * @return string|null
     */
    public function getGeoJson()
    {
        return $this->geoJson;
    }
    /**
     * Set geoJson value
     * @param string $geoJson
     * @return \StructType\LocalizacaoType
     */
    public function setGeoJson($geoJson = null)
    {
        // validation for constraint: string
        if (!is_null($geoJson) && !is_string($geoJson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geoJson)), __LINE__);
        }
        $this->geoJson = $geoJson;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LocalizacaoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
