<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FiltroPesquisaPrecadastroCnesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Código do CNES.
 * @subpackage Structs
 */
class FiltroPesquisaPrecadastroCnesType extends AbstractStructBase
{
    /**
     * The CodigoCNES
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: cnes:CodigoCNES
     * @var \StructType\CodigoCNESType
     */
    public $CodigoCNES;
    /**
     * The situacao
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $situacao;
    /**
     * Constructor method for FiltroPesquisaPrecadastroCnesType
     * @uses FiltroPesquisaPrecadastroCnesType::setCodigoCNES()
     * @uses FiltroPesquisaPrecadastroCnesType::setSituacao()
     * @param \StructType\CodigoCNESType $codigoCNES
     * @param string $situacao
     */
    public function __construct(\StructType\CodigoCNESType $codigoCNES = null, $situacao = null)
    {
        $this
            ->setCodigoCNES($codigoCNES)
            ->setSituacao($situacao);
    }
    /**
     * Get CodigoCNES value
     * @return \StructType\CodigoCNESType|null
     */
    public function getCodigoCNES()
    {
        return $this->CodigoCNES;
    }
    /**
     * Set CodigoCNES value
     * @param \StructType\CodigoCNESType $codigoCNES
     * @return \StructType\FiltroPesquisaPrecadastroCnesType
     */
    public function setCodigoCNES(\StructType\CodigoCNESType $codigoCNES = null)
    {
        $this->CodigoCNES = $codigoCNES;
        return $this;
    }
    /**
     * Get situacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSituacao()
    {
        return isset($this->situacao) ? $this->situacao : null;
    }
    /**
     * Set situacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\Situacao::valueIsValid()
     * @uses \EnumType\Situacao::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $situacao
     * @return \StructType\FiltroPesquisaPrecadastroCnesType
     */
    public function setSituacao($situacao = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Situacao::valueIsValid($situacao)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $situacao, implode(', ', \EnumType\Situacao::getValidValues())), __LINE__);
        }
        if (is_null($situacao) || (is_array($situacao) && empty($situacao))) {
            unset($this->situacao);
        } else {
            $this->situacao = $situacao;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FiltroPesquisaPrecadastroCnesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
