<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailType StructType
 * @subpackage Structs
 */
class EmailType extends AbstractStructBase
{
    /**
     * The descricaoEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Endereco de email.
     * - maxLength: 100
     * @var string
     */
    public $descricaoEmail;
    /**
     * The tipoEmail
     * Meta informations extracted from the WSDL
     * - documentation: Tipos de email: P-Principal, A-Alternativo.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tipoEmail;
    /**
     * The identificador
     * Meta informations extracted from the WSDL
     * - documentation: Código de identificação.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $identificador;
    /**
     * The validado
     * Meta informations extracted from the WSDL
     * - documentation: Indica se o email ja foi validado
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $validado;
    /**
     * Constructor method for EmailType
     * @uses EmailType::setDescricaoEmail()
     * @uses EmailType::setTipoEmail()
     * @uses EmailType::setIdentificador()
     * @uses EmailType::setValidado()
     * @param string $descricaoEmail
     * @param string $tipoEmail
     * @param int $identificador
     * @param bool $validado
     */
    public function __construct($descricaoEmail = null, $tipoEmail = null, $identificador = null, $validado = null)
    {
        $this
            ->setDescricaoEmail($descricaoEmail)
            ->setTipoEmail($tipoEmail)
            ->setIdentificador($identificador)
            ->setValidado($validado);
    }
    /**
     * Get descricaoEmail value
     * @return string
     */
    public function getDescricaoEmail()
    {
        return $this->descricaoEmail;
    }
    /**
     * Set descricaoEmail value
     * @param string $descricaoEmail
     * @return \StructType\EmailType
     */
    public function setDescricaoEmail($descricaoEmail = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($descricaoEmail) && strlen($descricaoEmail) > 100) || (is_array($descricaoEmail) && count($descricaoEmail) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($descricaoEmail) ? strlen($descricaoEmail) : count($descricaoEmail)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($descricaoEmail) && !is_string($descricaoEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricaoEmail)), __LINE__);
        }
        $this->descricaoEmail = $descricaoEmail;
        return $this;
    }
    /**
     * Get tipoEmail value
     * @return string
     */
    public function getTipoEmail()
    {
        return $this->tipoEmail;
    }
    /**
     * Set tipoEmail value
     * @uses \EnumType\TipoEmailType::valueIsValid()
     * @uses \EnumType\TipoEmailType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoEmail
     * @return \StructType\EmailType
     */
    public function setTipoEmail($tipoEmail = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoEmailType::valueIsValid($tipoEmail)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tipoEmail, implode(', ', \EnumType\TipoEmailType::getValidValues())), __LINE__);
        }
        $this->tipoEmail = $tipoEmail;
        return $this;
    }
    /**
     * Get identificador value
     * @return int|null
     */
    public function getIdentificador()
    {
        return $this->identificador;
    }
    /**
     * Set identificador value
     * @param int $identificador
     * @return \StructType\EmailType
     */
    public function setIdentificador($identificador = null)
    {
        // validation for constraint: int
        if (!is_null($identificador) && !is_numeric($identificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($identificador)), __LINE__);
        }
        $this->identificador = $identificador;
        return $this;
    }
    /**
     * Get validado value
     * @return bool|null
     */
    public function getValidado()
    {
        return $this->validado;
    }
    /**
     * Set validado value
     * @param bool $validado
     * @return \StructType\EmailType
     */
    public function setValidado($validado = null)
    {
        $this->validado = $validado;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
