<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DadosPreCadastroCNESType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Código do Estabelecimento de Saúde. | CPF do Estabelecimento de Saúde. | CNPJ do Estabelecimento de Saúde. | Endereço do Estabelecimetno de Saúde. | Email(s) do Estabelecimento de Saúde
 * @subpackage Structs
 */
class DadosPreCadastroCNESType extends AbstractStructBase
{
    /**
     * The CodigoCNES
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: codigocnes:CodigoCNES
     * @var \StructType\CodigoCNESType
     */
    public $CodigoCNES;
    /**
     * The CPF
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: cpf:CPF
     * @var \StructType\CPFType
     */
    public $CPF;
    /**
     * The CNPJ
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: cnpj:CNPJ
     * @var \StructType\CNPJType
     */
    public $CNPJ;
    /**
     * The NomeFantasia
     * Meta informations extracted from the WSDL
     * - documentation: Nome Fantasia do Estabelecimento de Saúde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NomeJuridicoType
     */
    public $NomeFantasia;
    /**
     * The NomeEmpresarial
     * Meta informations extracted from the WSDL
     * - documentation: Nome Empreserial do Estabelecimento de Saúde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NomeJuridicoType
     */
    public $NomeEmpresarial;
    /**
     * The NaturezaJuridica
     * Meta informations extracted from the WSDL
     * - documentation: Natureza Jurídica do Estabelecimento de Saúde.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturezaJuridicaType[]
     */
    public $NaturezaJuridica;
    /**
     * The CNPJMantenedora
     * Meta informations extracted from the WSDL
     * - documentation: CNPJ do Estabelecimento de Saúde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CNPJType
     */
    public $CNPJMantenedora;
    /**
     * The NaturezaJuridicaMantenedora
     * Meta informations extracted from the WSDL
     * - documentation: Natureza Jurídica da Mantenedora.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturezaJuridicaType[]
     */
    public $NaturezaJuridicaMantenedora;
    /**
     * The DataAtualizacao
     * Meta informations extracted from the WSDL
     * - documentation: Data da ultima atualização do pré-cadastro do estabelecimento de saúde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataAtualizacao;
    /**
     * The Endereco
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: endereco:Endereco
     * @var \StructType\EnderecoType
     */
    public $Endereco;
    /**
     * The Telefones
     * Meta informations extracted from the WSDL
     * - documentation: Telefone(s) do Estabelecimento de Saúde
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\TelefoneType[]
     */
    public $Telefones;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: email:Email
     * @var \StructType\EmailType[]
     */
    public $Email;
    /**
     * Constructor method for DadosPreCadastroCNESType
     * @uses DadosPreCadastroCNESType::setCodigoCNES()
     * @uses DadosPreCadastroCNESType::setCPF()
     * @uses DadosPreCadastroCNESType::setCNPJ()
     * @uses DadosPreCadastroCNESType::setNomeFantasia()
     * @uses DadosPreCadastroCNESType::setNomeEmpresarial()
     * @uses DadosPreCadastroCNESType::setNaturezaJuridica()
     * @uses DadosPreCadastroCNESType::setCNPJMantenedora()
     * @uses DadosPreCadastroCNESType::setNaturezaJuridicaMantenedora()
     * @uses DadosPreCadastroCNESType::setDataAtualizacao()
     * @uses DadosPreCadastroCNESType::setEndereco()
     * @uses DadosPreCadastroCNESType::setTelefones()
     * @uses DadosPreCadastroCNESType::setEmail()
     * @param \StructType\CodigoCNESType $codigoCNES
     * @param \StructType\CPFType $cPF
     * @param \StructType\CNPJType $cNPJ
     * @param \StructType\NomeJuridicoType $nomeFantasia
     * @param \StructType\NomeJuridicoType $nomeEmpresarial
     * @param \StructType\NaturezaJuridicaType[] $naturezaJuridica
     * @param \StructType\CNPJType $cNPJMantenedora
     * @param \StructType\NaturezaJuridicaType[] $naturezaJuridicaMantenedora
     * @param string $dataAtualizacao
     * @param \StructType\EnderecoType $endereco
     * @param \StructType\TelefoneType[] $telefones
     * @param \StructType\EmailType[] $email
     */
    public function __construct(\StructType\CodigoCNESType $codigoCNES = null, \StructType\CPFType $cPF = null, \StructType\CNPJType $cNPJ = null, \StructType\NomeJuridicoType $nomeFantasia = null, \StructType\NomeJuridicoType $nomeEmpresarial = null, array $naturezaJuridica = array(), \StructType\CNPJType $cNPJMantenedora = null, array $naturezaJuridicaMantenedora = array(), $dataAtualizacao = null, \StructType\EnderecoType $endereco = null, array $telefones = array(), array $email = array())
    {
        $this
            ->setCodigoCNES($codigoCNES)
            ->setCPF($cPF)
            ->setCNPJ($cNPJ)
            ->setNomeFantasia($nomeFantasia)
            ->setNomeEmpresarial($nomeEmpresarial)
            ->setNaturezaJuridica($naturezaJuridica)
            ->setCNPJMantenedora($cNPJMantenedora)
            ->setNaturezaJuridicaMantenedora($naturezaJuridicaMantenedora)
            ->setDataAtualizacao($dataAtualizacao)
            ->setEndereco($endereco)
            ->setTelefones($telefones)
            ->setEmail($email);
    }
    /**
     * Get CodigoCNES value
     * @return \StructType\CodigoCNESType
     */
    public function getCodigoCNES()
    {
        return $this->CodigoCNES;
    }
    /**
     * Set CodigoCNES value
     * @param \StructType\CodigoCNESType $codigoCNES
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function setCodigoCNES(\StructType\CodigoCNESType $codigoCNES = null)
    {
        $this->CodigoCNES = $codigoCNES;
        return $this;
    }
    /**
     * Get CPF value
     * @return \StructType\CPFType|null
     */
    public function getCPF()
    {
        return $this->CPF;
    }
    /**
     * Set CPF value
     * @param \StructType\CPFType $cPF
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function setCPF(\StructType\CPFType $cPF = null)
    {
        $this->CPF = $cPF;
        return $this;
    }
    /**
     * Get CNPJ value
     * @return \StructType\CNPJType|null
     */
    public function getCNPJ()
    {
        return $this->CNPJ;
    }
    /**
     * Set CNPJ value
     * @param \StructType\CNPJType $cNPJ
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function setCNPJ(\StructType\CNPJType $cNPJ = null)
    {
        $this->CNPJ = $cNPJ;
        return $this;
    }
    /**
     * Get NomeFantasia value
     * @return \StructType\NomeJuridicoType|null
     */
    public function getNomeFantasia()
    {
        return $this->NomeFantasia;
    }
    /**
     * Set NomeFantasia value
     * @param \StructType\NomeJuridicoType $nomeFantasia
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function setNomeFantasia(\StructType\NomeJuridicoType $nomeFantasia = null)
    {
        $this->NomeFantasia = $nomeFantasia;
        return $this;
    }
    /**
     * Get NomeEmpresarial value
     * @return \StructType\NomeJuridicoType|null
     */
    public function getNomeEmpresarial()
    {
        return $this->NomeEmpresarial;
    }
    /**
     * Set NomeEmpresarial value
     * @param \StructType\NomeJuridicoType $nomeEmpresarial
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function setNomeEmpresarial(\StructType\NomeJuridicoType $nomeEmpresarial = null)
    {
        $this->NomeEmpresarial = $nomeEmpresarial;
        return $this;
    }
    /**
     * Get NaturezaJuridica value
     * @return \StructType\NaturezaJuridicaType[]|null
     */
    public function getNaturezaJuridica()
    {
        return $this->NaturezaJuridica;
    }
    /**
     * Set NaturezaJuridica value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturezaJuridicaType[] $naturezaJuridica
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function setNaturezaJuridica(array $naturezaJuridica = array())
    {
        foreach ($naturezaJuridica as $dadosPreCadastroCNESTypeNaturezaJuridicaItem) {
            // validation for constraint: itemType
            if (!$dadosPreCadastroCNESTypeNaturezaJuridicaItem instanceof \StructType\NaturezaJuridicaType) {
                throw new \InvalidArgumentException(sprintf('The NaturezaJuridica property can only contain items of \StructType\NaturezaJuridicaType, "%s" given', is_object($dadosPreCadastroCNESTypeNaturezaJuridicaItem) ? get_class($dadosPreCadastroCNESTypeNaturezaJuridicaItem) : gettype($dadosPreCadastroCNESTypeNaturezaJuridicaItem)), __LINE__);
            }
        }
        $this->NaturezaJuridica = $naturezaJuridica;
        return $this;
    }
    /**
     * Add item to NaturezaJuridica value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturezaJuridicaType $item
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function addToNaturezaJuridica(\StructType\NaturezaJuridicaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturezaJuridicaType) {
            throw new \InvalidArgumentException(sprintf('The NaturezaJuridica property can only contain items of \StructType\NaturezaJuridicaType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NaturezaJuridica[] = $item;
        return $this;
    }
    /**
     * Get CNPJMantenedora value
     * @return \StructType\CNPJType|null
     */
    public function getCNPJMantenedora()
    {
        return $this->CNPJMantenedora;
    }
    /**
     * Set CNPJMantenedora value
     * @param \StructType\CNPJType $cNPJMantenedora
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function setCNPJMantenedora(\StructType\CNPJType $cNPJMantenedora = null)
    {
        $this->CNPJMantenedora = $cNPJMantenedora;
        return $this;
    }
    /**
     * Get NaturezaJuridicaMantenedora value
     * @return \StructType\NaturezaJuridicaType[]|null
     */
    public function getNaturezaJuridicaMantenedora()
    {
        return $this->NaturezaJuridicaMantenedora;
    }
    /**
     * Set NaturezaJuridicaMantenedora value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturezaJuridicaType[] $naturezaJuridicaMantenedora
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function setNaturezaJuridicaMantenedora(array $naturezaJuridicaMantenedora = array())
    {
        foreach ($naturezaJuridicaMantenedora as $dadosPreCadastroCNESTypeNaturezaJuridicaMantenedoraItem) {
            // validation for constraint: itemType
            if (!$dadosPreCadastroCNESTypeNaturezaJuridicaMantenedoraItem instanceof \StructType\NaturezaJuridicaType) {
                throw new \InvalidArgumentException(sprintf('The NaturezaJuridicaMantenedora property can only contain items of \StructType\NaturezaJuridicaType, "%s" given', is_object($dadosPreCadastroCNESTypeNaturezaJuridicaMantenedoraItem) ? get_class($dadosPreCadastroCNESTypeNaturezaJuridicaMantenedoraItem) : gettype($dadosPreCadastroCNESTypeNaturezaJuridicaMantenedoraItem)), __LINE__);
            }
        }
        $this->NaturezaJuridicaMantenedora = $naturezaJuridicaMantenedora;
        return $this;
    }
    /**
     * Add item to NaturezaJuridicaMantenedora value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturezaJuridicaType $item
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function addToNaturezaJuridicaMantenedora(\StructType\NaturezaJuridicaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturezaJuridicaType) {
            throw new \InvalidArgumentException(sprintf('The NaturezaJuridicaMantenedora property can only contain items of \StructType\NaturezaJuridicaType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NaturezaJuridicaMantenedora[] = $item;
        return $this;
    }
    /**
     * Get DataAtualizacao value
     * @return string|null
     */
    public function getDataAtualizacao()
    {
        return $this->DataAtualizacao;
    }
    /**
     * Set DataAtualizacao value
     * @param string $dataAtualizacao
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function setDataAtualizacao($dataAtualizacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataAtualizacao) && !is_string($dataAtualizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataAtualizacao)), __LINE__);
        }
        $this->DataAtualizacao = $dataAtualizacao;
        return $this;
    }
    /**
     * Get Endereco value
     * @return \StructType\EnderecoType|null
     */
    public function getEndereco()
    {
        return $this->Endereco;
    }
    /**
     * Set Endereco value
     * @param \StructType\EnderecoType $endereco
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function setEndereco(\StructType\EnderecoType $endereco = null)
    {
        $this->Endereco = $endereco;
        return $this;
    }
    /**
     * Get Telefones value
     * @return \StructType\TelefoneType[]|null
     */
    public function getTelefones()
    {
        return $this->Telefones;
    }
    /**
     * Set Telefones value
     * @throws \InvalidArgumentException
     * @param \StructType\TelefoneType[] $telefones
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function setTelefones(array $telefones = array())
    {
        foreach ($telefones as $dadosPreCadastroCNESTypeTelefonesItem) {
            // validation for constraint: itemType
            if (!$dadosPreCadastroCNESTypeTelefonesItem instanceof \StructType\TelefoneType) {
                throw new \InvalidArgumentException(sprintf('The Telefones property can only contain items of \StructType\TelefoneType, "%s" given', is_object($dadosPreCadastroCNESTypeTelefonesItem) ? get_class($dadosPreCadastroCNESTypeTelefonesItem) : gettype($dadosPreCadastroCNESTypeTelefonesItem)), __LINE__);
            }
        }
        $this->Telefones = $telefones;
        return $this;
    }
    /**
     * Add item to Telefones value
     * @throws \InvalidArgumentException
     * @param \StructType\TelefoneType $item
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function addToTelefones(\StructType\TelefoneType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TelefoneType) {
            throw new \InvalidArgumentException(sprintf('The Telefones property can only contain items of \StructType\TelefoneType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Telefones[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailType[] $email
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function setEmail(array $email = array())
    {
        foreach ($email as $dadosPreCadastroCNESTypeEmailItem) {
            // validation for constraint: itemType
            if (!$dadosPreCadastroCNESTypeEmailItem instanceof \StructType\EmailType) {
                throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \StructType\EmailType, "%s" given', is_object($dadosPreCadastroCNESTypeEmailItem) ? get_class($dadosPreCadastroCNESTypeEmailItem) : gettype($dadosPreCadastroCNESTypeEmailItem)), __LINE__);
            }
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailType $item
     * @return \StructType\DadosPreCadastroCNESType
     */
    public function addToEmail(\StructType\EmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \StructType\EmailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DadosPreCadastroCNESType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
