<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodigoUnidadeType StructType
 * @subpackage Structs
 */
class CodigoUnidadeType extends AbstractStructBase
{
    /**
     * The codigo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $codigo;
    /**
     * Constructor method for CodigoUnidadeType
     * @uses CodigoUnidadeType::setCodigo()
     * @param string $codigo
     */
    public function __construct($codigo = null)
    {
        $this
            ->setCodigo($codigo);
    }
    /**
     * Get codigo value
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @uses \EnumType\Codigo::valueIsValid()
     * @uses \EnumType\Codigo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codigo
     * @return \StructType\CodigoUnidadeType
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Codigo::valueIsValid($codigo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $codigo, implode(', ', \EnumType\Codigo::getValidValues())), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CodigoUnidadeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
