<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CNPJType StructType
 * @subpackage Structs
 */
class CNPJType extends AbstractStructBase
{
    /**
     * The numeroCNPJ
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Numero do CNPJ sem formatacao. Ex: 09999999999999
     * - maxLength: 14
     * - minLength: 14
     * - pattern: [0-9]*
     * @var string
     */
    public $numeroCNPJ;
    /**
     * Constructor method for CNPJType
     * @uses CNPJType::setNumeroCNPJ()
     * @param string $numeroCNPJ
     */
    public function __construct($numeroCNPJ = null)
    {
        $this
            ->setNumeroCNPJ($numeroCNPJ);
    }
    /**
     * Get numeroCNPJ value
     * @return string
     */
    public function getNumeroCNPJ()
    {
        return $this->numeroCNPJ;
    }
    /**
     * Set numeroCNPJ value
     * @param string $numeroCNPJ
     * @return \StructType\CNPJType
     */
    public function setNumeroCNPJ($numeroCNPJ = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numeroCNPJ) && strlen($numeroCNPJ) > 14) || (is_array($numeroCNPJ) && count($numeroCNPJ) > 14)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 14 element(s) or a scalar of 14 character(s) at most, "%d" length given', is_scalar($numeroCNPJ) ? strlen($numeroCNPJ) : count($numeroCNPJ)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($numeroCNPJ) && strlen($numeroCNPJ) < 14) || (is_array($numeroCNPJ) && count($numeroCNPJ) < 14)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 14 element(s) or a scalar of 14 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($numeroCNPJ) && !preg_match('/[0-9]*/', $numeroCNPJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($numeroCNPJ, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numeroCNPJ) && !is_string($numeroCNPJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroCNPJ)), __LINE__);
        }
        $this->numeroCNPJ = $numeroCNPJ;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CNPJType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
