<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CEPType StructType
 * @subpackage Structs
 */
class CEPType extends AbstractStructBase
{
    /**
     * The numeroCEP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: Este esquema representa o CEP. Ex: 70000000 (sem formatacao)
     * - maxLength: 8
     * - minLength: 8
     * - pattern: [0-9]*
     * @var string
     */
    public $numeroCEP;
    /**
     * Constructor method for CEPType
     * @uses CEPType::setNumeroCEP()
     * @param string $numeroCEP
     */
    public function __construct($numeroCEP = null)
    {
        $this
            ->setNumeroCEP($numeroCEP);
    }
    /**
     * Get numeroCEP value
     * @return string
     */
    public function getNumeroCEP()
    {
        return $this->numeroCEP;
    }
    /**
     * Set numeroCEP value
     * @param string $numeroCEP
     * @return \StructType\CEPType
     */
    public function setNumeroCEP($numeroCEP = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numeroCEP) && strlen($numeroCEP) > 8) || (is_array($numeroCEP) && count($numeroCEP) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($numeroCEP) ? strlen($numeroCEP) : count($numeroCEP)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($numeroCEP) && strlen($numeroCEP) < 8) || (is_array($numeroCEP) && count($numeroCEP) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($numeroCEP) && !preg_match('/[0-9]*/', $numeroCEP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($numeroCEP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numeroCEP) && !is_string($numeroCEP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroCEP)), __LINE__);
        }
        $this->numeroCEP = $numeroCEP;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CEPType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
