<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consultar ServiceType
 * @subpackage Services
 */
class Consultar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named consultarEstabelecimentoSaude
     * Meta informations extracted from the WSDL
     * - documentation: Consultar os dados básicos do Estabelecimento de Saude pelo código do CNES. | Consultar os dados básicos do Estabelecimento de Saude pelo código do CNES. | Consultar os dados básicos do Estabelecimento de Saude pelo código do
     * CNES.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RequestConsultarEstabelecimentoSaude $requestConsultarEstabelecimentoSaude
     * @return \StructType\ResponseConsultarEstabelecimentoSaude|bool
     */
    public function consultarEstabelecimentoSaude(\StructType\RequestConsultarEstabelecimentoSaude $requestConsultarEstabelecimentoSaude)
    {
        try {
            $this->setResult(self::getSoapClient()->consultarEstabelecimentoSaude($requestConsultarEstabelecimentoSaude));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultarPrecadastroCNES
     * Meta informations extracted from the WSDL
     * - documentation: Consultar os dados básicos do precadastro do Estabelecimento de Saude pelo código do CNES. | Consultar os dados do precadastro do Estabelecimento de Saude pelo código do CNES. | Consultar os dados do precadastro do Estabelecimento
     * de Saude pelo código do CNES.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RequestConsultarPrecadastroCNES $requestConsultarPrecadastroCNES
     * @return \StructType\ResponseConsultarPrecadastroCNES|bool
     */
    public function consultarPrecadastroCNES(\StructType\RequestConsultarPrecadastroCNES $requestConsultarPrecadastroCNES)
    {
        try {
            $this->setResult(self::getSoapClient()->consultarPrecadastroCNES($requestConsultarPrecadastroCNES));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseConsultarEstabelecimentoSaude|\StructType\ResponseConsultarPrecadastroCNES
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
