<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchResults StructType
 * @subpackage Structs
 */
class SearchResults extends AbstractStructBase
{
    /**
     * The Parcelshop
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GLSParcelShop
     */
    public $Parcelshop;
    /**
     * The AirLineDistance
     * @var string
     */
    public $AirLineDistance;
    /**
     * Constructor method for SearchResults
     * @uses SearchResults::setParcelshop()
     * @uses SearchResults::setAirLineDistance()
     * @param \StructType\GLSParcelShop $parcelshop
     * @param string $airLineDistance
     */
    public function __construct(\StructType\GLSParcelShop $parcelshop = null, $airLineDistance = null)
    {
        $this
            ->setParcelshop($parcelshop)
            ->setAirLineDistance($airLineDistance);
    }
    /**
     * Get Parcelshop value
     * @return \StructType\GLSParcelShop|null
     */
    public function getParcelshop()
    {
        return $this->Parcelshop;
    }
    /**
     * Set Parcelshop value
     * @param \StructType\GLSParcelShop $parcelshop
     * @return \StructType\SearchResults
     */
    public function setParcelshop(\StructType\GLSParcelShop $parcelshop = null)
    {
        $this->Parcelshop = $parcelshop;
        return $this;
    }
    /**
     * Get AirLineDistance value
     * @return string|null
     */
    public function getAirLineDistance()
    {
        return $this->AirLineDistance;
    }
    /**
     * Set AirLineDistance value
     * @param string $airLineDistance
     * @return \StructType\SearchResults
     */
    public function setAirLineDistance($airLineDistance = null)
    {
        // validation for constraint: string
        if (!is_null($airLineDistance) && !is_string($airLineDistance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airLineDistance)), __LINE__);
        }
        $this->AirLineDistance = $airLineDistance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
