<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetParcelShopReponseType StructType
 * @subpackage Structs
 */
class GetParcelShopReponseType extends AbstractStructBase
{
    /**
     * The exitCode
     * @var \StructType\GLSExitCode
     */
    public $exitCode;
    /**
     * The SearchResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchResults[]
     */
    public $SearchResults;
    /**
     * Constructor method for GetParcelShopReponseType
     * @uses GetParcelShopReponseType::setExitCode()
     * @uses GetParcelShopReponseType::setSearchResults()
     * @param \StructType\GLSExitCode $exitCode
     * @param \StructType\SearchResults[] $searchResults
     */
    public function __construct(\StructType\GLSExitCode $exitCode = null, array $searchResults = array())
    {
        $this
            ->setExitCode($exitCode)
            ->setSearchResults($searchResults);
    }
    /**
     * Get exitCode value
     * @return \StructType\GLSExitCode|null
     */
    public function getExitCode()
    {
        return $this->exitCode;
    }
    /**
     * Set exitCode value
     * @param \StructType\GLSExitCode $exitCode
     * @return \StructType\GetParcelShopReponseType
     */
    public function setExitCode(\StructType\GLSExitCode $exitCode = null)
    {
        $this->exitCode = $exitCode;
        return $this;
    }
    /**
     * Get SearchResults value
     * @return \StructType\SearchResults[]|null
     */
    public function getSearchResults()
    {
        return $this->SearchResults;
    }
    /**
     * Set SearchResults value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchResults[] $searchResults
     * @return \StructType\GetParcelShopReponseType
     */
    public function setSearchResults(array $searchResults = array())
    {
        foreach ($searchResults as $getParcelShopReponseTypeSearchResultsItem) {
            // validation for constraint: itemType
            if (!$getParcelShopReponseTypeSearchResultsItem instanceof \StructType\SearchResults) {
                throw new \InvalidArgumentException(sprintf('The SearchResults property can only contain items of \StructType\SearchResults, "%s" given', is_object($getParcelShopReponseTypeSearchResultsItem) ? get_class($getParcelShopReponseTypeSearchResultsItem) : gettype($getParcelShopReponseTypeSearchResultsItem)), __LINE__);
            }
        }
        $this->SearchResults = $searchResults;
        return $this;
    }
    /**
     * Add item to SearchResults value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchResults $item
     * @return \StructType\GetParcelShopReponseType
     */
    public function addToSearchResults(\StructType\SearchResults $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchResults) {
            throw new \InvalidArgumentException(sprintf('The SearchResults property can only contain items of \StructType\SearchResults, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SearchResults[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetParcelShopReponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
