<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetParcelShopInAreaResponse StructType
 * Meta informations extracted from the WSDL
 * - type: gls:GetParcelShopInAreaResponse
 * @subpackage Structs
 */
class GetParcelShopInAreaResponse extends AbstractStructBase
{
    /**
     * The ExitCode
     * @var \StructType\GLSExitCode
     */
    public $ExitCode;
    /**
     * The ParcelShop
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100000
     * - minOccurs: 0
     * @var \StructType\GLSParcelShop[]
     */
    public $ParcelShop;
    /**
     * Constructor method for GetParcelShopInAreaResponse
     * @uses GetParcelShopInAreaResponse::setExitCode()
     * @uses GetParcelShopInAreaResponse::setParcelShop()
     * @param \StructType\GLSExitCode $exitCode
     * @param \StructType\GLSParcelShop[] $parcelShop
     */
    public function __construct(\StructType\GLSExitCode $exitCode = null, array $parcelShop = array())
    {
        $this
            ->setExitCode($exitCode)
            ->setParcelShop($parcelShop);
    }
    /**
     * Get ExitCode value
     * @return \StructType\GLSExitCode|null
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \StructType\GLSExitCode $exitCode
     * @return \StructType\GetParcelShopInAreaResponse
     */
    public function setExitCode(\StructType\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get ParcelShop value
     * @return \StructType\GLSParcelShop[]|null
     */
    public function getParcelShop()
    {
        return $this->ParcelShop;
    }
    /**
     * Set ParcelShop value
     * @throws \InvalidArgumentException
     * @param \StructType\GLSParcelShop[] $parcelShop
     * @return \StructType\GetParcelShopInAreaResponse
     */
    public function setParcelShop(array $parcelShop = array())
    {
        foreach ($parcelShop as $getParcelShopInAreaResponseParcelShopItem) {
            // validation for constraint: itemType
            if (!$getParcelShopInAreaResponseParcelShopItem instanceof \StructType\GLSParcelShop) {
                throw new \InvalidArgumentException(sprintf('The ParcelShop property can only contain items of \StructType\GLSParcelShop, "%s" given', is_object($getParcelShopInAreaResponseParcelShopItem) ? get_class($getParcelShopInAreaResponseParcelShopItem) : gettype($getParcelShopInAreaResponseParcelShopItem)), __LINE__);
            }
        }
        $this->ParcelShop = $parcelShop;
        return $this;
    }
    /**
     * Add item to ParcelShop value
     * @throws \InvalidArgumentException
     * @param \StructType\GLSParcelShop $item
     * @return \StructType\GetParcelShopInAreaResponse
     */
    public function addToParcelShop(\StructType\GLSParcelShop $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GLSParcelShop) {
            throw new \InvalidArgumentException(sprintf('The ParcelShop property can only contain items of \StructType\GLSParcelShop, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ParcelShop[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetParcelShopInAreaResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
