<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetParcelShopByIdRequestType StructType
 * @subpackage Structs
 */
class GetParcelShopByIdRequestType extends AbstractStructBase
{
    /**
     * The ParcelShopId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ParcelShopId;
    /**
     * The Credentials
     * @var \StructType\GLSUserCredentials
     */
    public $Credentials;
    /**
     * Constructor method for GetParcelShopByIdRequestType
     * @uses GetParcelShopByIdRequestType::setParcelShopId()
     * @uses GetParcelShopByIdRequestType::setCredentials()
     * @param string $parcelShopId
     * @param \StructType\GLSUserCredentials $credentials
     */
    public function __construct($parcelShopId = null, \StructType\GLSUserCredentials $credentials = null)
    {
        $this
            ->setParcelShopId($parcelShopId)
            ->setCredentials($credentials);
    }
    /**
     * Get ParcelShopId value
     * @return string
     */
    public function getParcelShopId()
    {
        return $this->ParcelShopId;
    }
    /**
     * Set ParcelShopId value
     * @param string $parcelShopId
     * @return \StructType\GetParcelShopByIdRequestType
     */
    public function setParcelShopId($parcelShopId = null)
    {
        // validation for constraint: string
        if (!is_null($parcelShopId) && !is_string($parcelShopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parcelShopId)), __LINE__);
        }
        $this->ParcelShopId = $parcelShopId;
        return $this;
    }
    /**
     * Get Credentials value
     * @return \StructType\GLSUserCredentials|null
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \StructType\GLSUserCredentials $credentials
     * @return \StructType\GetParcelShopByIdRequestType
     */
    public function setCredentials(\StructType\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetParcelShopByIdRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
