<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetParcelShopByCountryCodeResponseType StructType
 * @subpackage Structs
 */
class GetParcelShopByCountryCodeResponseType extends AbstractStructBase
{
    /**
     * The ExitCode
     * @var \StructType\GLSExitCode
     */
    public $ExitCode;
    /**
     * The ParcelShops
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100000
     * - minOccurs: 0
     * @var \StructType\GLSParcelShop[]
     */
    public $ParcelShops;
    /**
     * Constructor method for GetParcelShopByCountryCodeResponseType
     * @uses GetParcelShopByCountryCodeResponseType::setExitCode()
     * @uses GetParcelShopByCountryCodeResponseType::setParcelShops()
     * @param \StructType\GLSExitCode $exitCode
     * @param \StructType\GLSParcelShop[] $parcelShops
     */
    public function __construct(\StructType\GLSExitCode $exitCode = null, array $parcelShops = array())
    {
        $this
            ->setExitCode($exitCode)
            ->setParcelShops($parcelShops);
    }
    /**
     * Get ExitCode value
     * @return \StructType\GLSExitCode|null
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \StructType\GLSExitCode $exitCode
     * @return \StructType\GetParcelShopByCountryCodeResponseType
     */
    public function setExitCode(\StructType\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get ParcelShops value
     * @return \StructType\GLSParcelShop[]|null
     */
    public function getParcelShops()
    {
        return $this->ParcelShops;
    }
    /**
     * Set ParcelShops value
     * @throws \InvalidArgumentException
     * @param \StructType\GLSParcelShop[] $parcelShops
     * @return \StructType\GetParcelShopByCountryCodeResponseType
     */
    public function setParcelShops(array $parcelShops = array())
    {
        foreach ($parcelShops as $getParcelShopByCountryCodeResponseTypeParcelShopsItem) {
            // validation for constraint: itemType
            if (!$getParcelShopByCountryCodeResponseTypeParcelShopsItem instanceof \StructType\GLSParcelShop) {
                throw new \InvalidArgumentException(sprintf('The ParcelShops property can only contain items of \StructType\GLSParcelShop, "%s" given', is_object($getParcelShopByCountryCodeResponseTypeParcelShopsItem) ? get_class($getParcelShopByCountryCodeResponseTypeParcelShopsItem) : gettype($getParcelShopByCountryCodeResponseTypeParcelShopsItem)), __LINE__);
            }
        }
        $this->ParcelShops = $parcelShops;
        return $this;
    }
    /**
     * Add item to ParcelShops value
     * @throws \InvalidArgumentException
     * @param \StructType\GLSParcelShop $item
     * @return \StructType\GetParcelShopByCountryCodeResponseType
     */
    public function addToParcelShops(\StructType\GLSParcelShop $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GLSParcelShop) {
            throw new \InvalidArgumentException(sprintf('The ParcelShops property can only contain items of \StructType\GLSParcelShop, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ParcelShops[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetParcelShopByCountryCodeResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
