<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetParcelShopByCountryCodeRequestType StructType
 * @subpackage Structs
 */
class GetParcelShopByCountryCodeRequestType extends AbstractStructBase
{
    /**
     * The Credentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for GetParcelShopByCountryCodeRequestType
     * @uses GetParcelShopByCountryCodeRequestType::setCredentials()
     * @uses GetParcelShopByCountryCodeRequestType::setCountryCode()
     * @param \StructType\GLSUserCredentials $credentials
     * @param string $countryCode
     */
    public function __construct(\StructType\GLSUserCredentials $credentials = null, $countryCode = null)
    {
        $this
            ->setCredentials($credentials)
            ->setCountryCode($countryCode);
    }
    /**
     * Get Credentials value
     * @return \StructType\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \StructType\GLSUserCredentials $credentials
     * @return \StructType\GetParcelShopByCountryCodeRequestType
     */
    public function setCredentials(\StructType\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\GetParcelShopByCountryCodeRequestType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetParcelShopByCountryCodeRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
