<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSWorkingDay StructType
 * @subpackage Structs
 */
class GLSWorkingDay extends AbstractStructBase
{
    /**
     * The Day
     * @var string
     */
    public $Day;
    /**
     * The OpeningHours
     * @var \StructType\OpeningHours
     */
    public $OpeningHours;
    /**
     * The Breaks
     * @var \StructType\Breaks
     */
    public $Breaks;
    /**
     * Constructor method for GLSWorkingDay
     * @uses GLSWorkingDay::setDay()
     * @uses GLSWorkingDay::setOpeningHours()
     * @uses GLSWorkingDay::setBreaks()
     * @param string $day
     * @param \StructType\OpeningHours $openingHours
     * @param \StructType\Breaks $breaks
     */
    public function __construct($day = null, \StructType\OpeningHours $openingHours = null, \StructType\Breaks $breaks = null)
    {
        $this
            ->setDay($day)
            ->setOpeningHours($openingHours)
            ->setBreaks($breaks);
    }
    /**
     * Get Day value
     * @return string|null
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param string $day
     * @return \StructType\GLSWorkingDay
     */
    public function setDay($day = null)
    {
        // validation for constraint: string
        if (!is_null($day) && !is_string($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($day)), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Get OpeningHours value
     * @return \StructType\OpeningHours|null
     */
    public function getOpeningHours()
    {
        return $this->OpeningHours;
    }
    /**
     * Set OpeningHours value
     * @param \StructType\OpeningHours $openingHours
     * @return \StructType\GLSWorkingDay
     */
    public function setOpeningHours(\StructType\OpeningHours $openingHours = null)
    {
        $this->OpeningHours = $openingHours;
        return $this;
    }
    /**
     * Get Breaks value
     * @return \StructType\Breaks|null
     */
    public function getBreaks()
    {
        return $this->Breaks;
    }
    /**
     * Set Breaks value
     * @param \StructType\Breaks $breaks
     * @return \StructType\GLSWorkingDay
     */
    public function setBreaks(\StructType\Breaks $breaks = null)
    {
        $this->Breaks = $breaks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GLSWorkingDay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
