<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSParcelShop StructType
 * @subpackage Structs
 */
class GLSParcelShop extends AbstractStructBase
{
    /**
     * The ParcelShopId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ParcelShopId;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GLSAddress
     */
    public $Address;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GLSPhonenumber
     */
    public $Phone;
    /**
     * The Mobile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GLSPhonenumber
     */
    public $Mobile;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GLSPhonenumber
     */
    public $Fax;
    /**
     * The Email
     * @var string
     */
    public $Email;
    /**
     * The URL
     * @var string
     */
    public $URL;
    /**
     * The GLSCoordinates
     * @var \StructType\GLSCoordinates
     */
    public $GLSCoordinates;
    /**
     * The GLSWorkingDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * @var \StructType\GLSWorkingDay[]
     */
    public $GLSWorkingDay;
    /**
     * Constructor method for GLSParcelShop
     * @uses GLSParcelShop::setParcelShopId()
     * @uses GLSParcelShop::setAddress()
     * @uses GLSParcelShop::setPhone()
     * @uses GLSParcelShop::setMobile()
     * @uses GLSParcelShop::setFax()
     * @uses GLSParcelShop::setEmail()
     * @uses GLSParcelShop::setURL()
     * @uses GLSParcelShop::setGLSCoordinates()
     * @uses GLSParcelShop::setGLSWorkingDay()
     * @param string $parcelShopId
     * @param \StructType\GLSAddress $address
     * @param \StructType\GLSPhonenumber $phone
     * @param \StructType\GLSPhonenumber $mobile
     * @param \StructType\GLSPhonenumber $fax
     * @param string $email
     * @param string $uRL
     * @param \StructType\GLSCoordinates $gLSCoordinates
     * @param \StructType\GLSWorkingDay[] $gLSWorkingDay
     */
    public function __construct($parcelShopId = null, \StructType\GLSAddress $address = null, \StructType\GLSPhonenumber $phone = null, \StructType\GLSPhonenumber $mobile = null, \StructType\GLSPhonenumber $fax = null, $email = null, $uRL = null, \StructType\GLSCoordinates $gLSCoordinates = null, array $gLSWorkingDay = array())
    {
        $this
            ->setParcelShopId($parcelShopId)
            ->setAddress($address)
            ->setPhone($phone)
            ->setMobile($mobile)
            ->setFax($fax)
            ->setEmail($email)
            ->setURL($uRL)
            ->setGLSCoordinates($gLSCoordinates)
            ->setGLSWorkingDay($gLSWorkingDay);
    }
    /**
     * Get ParcelShopId value
     * @return string
     */
    public function getParcelShopId()
    {
        return $this->ParcelShopId;
    }
    /**
     * Set ParcelShopId value
     * @param string $parcelShopId
     * @return \StructType\GLSParcelShop
     */
    public function setParcelShopId($parcelShopId = null)
    {
        // validation for constraint: string
        if (!is_null($parcelShopId) && !is_string($parcelShopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parcelShopId)), __LINE__);
        }
        $this->ParcelShopId = $parcelShopId;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\GLSAddress
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\GLSAddress $address
     * @return \StructType\GLSParcelShop
     */
    public function setAddress(\StructType\GLSAddress $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Phone value
     * @return \StructType\GLSPhonenumber|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param \StructType\GLSPhonenumber $phone
     * @return \StructType\GLSParcelShop
     */
    public function setPhone(\StructType\GLSPhonenumber $phone = null)
    {
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Mobile value
     * @return \StructType\GLSPhonenumber|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param \StructType\GLSPhonenumber $mobile
     * @return \StructType\GLSParcelShop
     */
    public function setMobile(\StructType\GLSPhonenumber $mobile = null)
    {
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get Fax value
     * @return \StructType\GLSPhonenumber|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param \StructType\GLSPhonenumber $fax
     * @return \StructType\GLSParcelShop
     */
    public function setFax(\StructType\GLSPhonenumber $fax = null)
    {
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\GLSParcelShop
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\GLSParcelShop
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get GLSCoordinates value
     * @return \StructType\GLSCoordinates|null
     */
    public function getGLSCoordinates()
    {
        return $this->GLSCoordinates;
    }
    /**
     * Set GLSCoordinates value
     * @param \StructType\GLSCoordinates $gLSCoordinates
     * @return \StructType\GLSParcelShop
     */
    public function setGLSCoordinates(\StructType\GLSCoordinates $gLSCoordinates = null)
    {
        $this->GLSCoordinates = $gLSCoordinates;
        return $this;
    }
    /**
     * Get GLSWorkingDay value
     * @return \StructType\GLSWorkingDay[]|null
     */
    public function getGLSWorkingDay()
    {
        return $this->GLSWorkingDay;
    }
    /**
     * Set GLSWorkingDay value
     * @throws \InvalidArgumentException
     * @param \StructType\GLSWorkingDay[] $gLSWorkingDay
     * @return \StructType\GLSParcelShop
     */
    public function setGLSWorkingDay(array $gLSWorkingDay = array())
    {
        foreach ($gLSWorkingDay as $gLSParcelShopGLSWorkingDayItem) {
            // validation for constraint: itemType
            if (!$gLSParcelShopGLSWorkingDayItem instanceof \StructType\GLSWorkingDay) {
                throw new \InvalidArgumentException(sprintf('The GLSWorkingDay property can only contain items of \StructType\GLSWorkingDay, "%s" given', is_object($gLSParcelShopGLSWorkingDayItem) ? get_class($gLSParcelShopGLSWorkingDayItem) : gettype($gLSParcelShopGLSWorkingDayItem)), __LINE__);
            }
        }
        $this->GLSWorkingDay = $gLSWorkingDay;
        return $this;
    }
    /**
     * Add item to GLSWorkingDay value
     * @throws \InvalidArgumentException
     * @param \StructType\GLSWorkingDay $item
     * @return \StructType\GLSParcelShop
     */
    public function addToGLSWorkingDay(\StructType\GLSWorkingDay $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GLSWorkingDay) {
            throw new \InvalidArgumentException(sprintf('The GLSWorkingDay property can only contain items of \StructType\GLSWorkingDay, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GLSWorkingDay[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GLSParcelShop
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
