<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSExitCode StructType
 * @subpackage Structs
 */
class GLSExitCode extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorDscr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorDscr;
    /**
     * Constructor method for GLSExitCode
     * @uses GLSExitCode::setErrorCode()
     * @uses GLSExitCode::setErrorDscr()
     * @param int $errorCode
     * @param string $errorDscr
     */
    public function __construct($errorCode = null, $errorDscr = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorDscr($errorDscr);
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\GLSExitCode
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorDscr value
     * @return string
     */
    public function getErrorDscr()
    {
        return $this->ErrorDscr;
    }
    /**
     * Set ErrorDscr value
     * @param string $errorDscr
     * @return \StructType\GLSExitCode
     */
    public function setErrorDscr($errorDscr = null)
    {
        // validation for constraint: string
        if (!is_null($errorDscr) && !is_string($errorDscr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorDscr)), __LINE__);
        }
        $this->ErrorDscr = $errorDscr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GLSExitCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
