<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetParcelShopById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetParcelShopByIdRequestType $getParcelShopByIdRequest
     * @return \StructType\GetParcelShopByIdResponseType|bool
     */
    public function GetParcelShopById(\StructType\GetParcelShopByIdRequestType $getParcelShopByIdRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetParcelShopById($getParcelShopByIdRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetParcelShops
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetParcelShopRequestType $getParcelShopsRequest
     * @return \StructType\GetParcelShopReponseType|bool
     */
    public function GetParcelShops(\StructType\GetParcelShopRequestType $getParcelShopsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetParcelShops($getParcelShopsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetParcelShopByCountryCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetParcelShopByCountryCodeRequestType $getParcelShopByCountryCodeRequest
     * @return \StructType\GetParcelShopByCountryCodeResponseType|bool
     */
    public function GetParcelShopByCountryCode(\StructType\GetParcelShopByCountryCodeRequestType $getParcelShopByCountryCodeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetParcelShopByCountryCode($getParcelShopByCountryCodeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetParcelShopInArea
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetParcelShopInAreaRequestType $getParcelShopInAreaRequest
     * @return \StructType\GetParcelShopInAreaResponse|bool
     */
    public function GetParcelShopInArea(\StructType\GetParcelShopInAreaRequestType $getParcelShopInAreaRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetParcelShopInArea($getParcelShopInAreaRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetParcelShopByCountryCodeResponseType|\StructType\GetParcelShopByIdResponseType|\StructType\GetParcelShopInAreaResponse|\StructType\GetParcelShopReponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
