<?php

namespace App\Api\Client\Magento\Type\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shoppingCartProductEntity StructType
 * @subpackage Structs
 */
class ShoppingCartProductEntity extends AbstractStructBase
{
    /**
     * The product_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $product_id;
    /**
     * The sku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * The qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $qty;
    /**
     * The options
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\AssociativeArray
     */
    public $options;
    /**
     * The bundle_option
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\AssociativeArray
     */
    public $bundle_option;
    /**
     * The bundle_option_qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\AssociativeArray
     */
    public $bundle_option_qty;
    /**
     * The links
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Api\Client\Magento\Type\ArrayType\ArrayOfString
     */
    public $links;
    /**
     * Constructor method for shoppingCartProductEntity
     * @uses ShoppingCartProductEntity::setProduct_id()
     * @uses ShoppingCartProductEntity::setSku()
     * @uses ShoppingCartProductEntity::setQty()
     * @uses ShoppingCartProductEntity::setOptions()
     * @uses ShoppingCartProductEntity::setBundle_option()
     * @uses ShoppingCartProductEntity::setBundle_option_qty()
     * @uses ShoppingCartProductEntity::setLinks()
     * @param string $product_id
     * @param string $sku
     * @param float $qty
     * @param \App\Api\Client\Magento\Type\ArrayType\AssociativeArray $options
     * @param \App\Api\Client\Magento\Type\ArrayType\AssociativeArray $bundle_option
     * @param \App\Api\Client\Magento\Type\ArrayType\AssociativeArray $bundle_option_qty
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $links
     */
    public function __construct($product_id = null, $sku = null, $qty = null, \App\Api\Client\Magento\Type\ArrayType\AssociativeArray $options = null, \App\Api\Client\Magento\Type\ArrayType\AssociativeArray $bundle_option = null, \App\Api\Client\Magento\Type\ArrayType\AssociativeArray $bundle_option_qty = null, \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $links = null)
    {
        $this
            ->setProduct_id($product_id)
            ->setSku($sku)
            ->setQty($qty)
            ->setOptions($options)
            ->setBundle_option($bundle_option)
            ->setBundle_option_qty($bundle_option_qty)
            ->setLinks($links);
    }
    /**
     * Get product_id value
     * @return string|null
     */
    public function getProduct_id()
    {
        return $this->product_id;
    }
    /**
     * Set product_id value
     * @param string $product_id
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductEntity
     */
    public function setProduct_id($product_id = null)
    {
        // validation for constraint: string
        if (!is_null($product_id) && !is_string($product_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product_id)), __LINE__);
        }
        $this->product_id = $product_id;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductEntity
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get qty value
     * @return float|null
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param float $qty
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductEntity
     */
    public function setQty($qty = null)
    {
        $this->qty = $qty;
        return $this;
    }
    /**
     * Get options value
     * @return \App\Api\Client\Magento\Type\ArrayType\AssociativeArray|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \App\Api\Client\Magento\Type\ArrayType\AssociativeArray $options
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductEntity
     */
    public function setOptions(\App\Api\Client\Magento\Type\ArrayType\AssociativeArray $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get bundle_option value
     * @return \App\Api\Client\Magento\Type\ArrayType\AssociativeArray|null
     */
    public function getBundle_option()
    {
        return $this->bundle_option;
    }
    /**
     * Set bundle_option value
     * @param \App\Api\Client\Magento\Type\ArrayType\AssociativeArray $bundle_option
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductEntity
     */
    public function setBundle_option(\App\Api\Client\Magento\Type\ArrayType\AssociativeArray $bundle_option = null)
    {
        $this->bundle_option = $bundle_option;
        return $this;
    }
    /**
     * Get bundle_option_qty value
     * @return \App\Api\Client\Magento\Type\ArrayType\AssociativeArray|null
     */
    public function getBundle_option_qty()
    {
        return $this->bundle_option_qty;
    }
    /**
     * Set bundle_option_qty value
     * @param \App\Api\Client\Magento\Type\ArrayType\AssociativeArray $bundle_option_qty
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductEntity
     */
    public function setBundle_option_qty(\App\Api\Client\Magento\Type\ArrayType\AssociativeArray $bundle_option_qty = null)
    {
        $this->bundle_option_qty = $bundle_option_qty;
        return $this;
    }
    /**
     * Get links value
     * @return \App\Api\Client\Magento\Type\ArrayType\ArrayOfString|null
     */
    public function getLinks()
    {
        return $this->links;
    }
    /**
     * Set links value
     * @param \App\Api\Client\Magento\Type\ArrayType\ArrayOfString $links
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductEntity
     */
    public function setLinks(\App\Api\Client\Magento\Type\ArrayType\ArrayOfString $links = null)
    {
        $this->links = $links;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Api\Client\Magento\Type\StructType\ShoppingCartProductEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
